"use strict";
/********************************************************************************
 * Copyright (C) 2018 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.bindProcessTaskRunnerModule = void 0;
var inversify_1 = require("@theia/core/shared/inversify");
var process_task_1 = require("./process-task");
var process_task_runner_1 = require("./process-task-runner");
var process_task_runner_contribution_1 = require("./process-task-runner-contribution");
var task_runner_1 = require("../task-runner");
function bindProcessTaskRunnerModule(bind) {
    bind(process_task_1.ProcessTask).toSelf().inTransientScope();
    bind(process_task_1.TaskFactory).toFactory(function (ctx) {
        return function (options) {
            var child = new inversify_1.Container({ defaultScope: 'Singleton' });
            child.parent = ctx.container;
            child.bind(process_task_1.TaskProcessOptions).toConstantValue(options);
            return child.get(process_task_1.ProcessTask);
        };
    });
    bind(process_task_runner_1.ProcessTaskRunner).toSelf().inSingletonScope();
    bind(process_task_runner_contribution_1.ProcessTaskRunnerContribution).toSelf().inSingletonScope();
    bind(task_runner_1.TaskRunnerContribution).toService(process_task_runner_contribution_1.ProcessTaskRunnerContribution);
}
exports.bindProcessTaskRunnerModule = bindProcessTaskRunnerModule;
//# sourceMappingURL=process-task-runner-backend-module.js.map