"use strict";
/********************************************************************************
 * Copyright (C) 2020 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var chai = require("chai");
var uri_1 = require("@theia/core/lib/common/uri");
var inversify_1 = require("@theia/core/shared/inversify");
var vsx_environment_1 = require("./vsx-environment");
var vsx_registry_api_1 = require("./vsx-registry-api");
var vsx_api_version_provider_1 = require("./vsx-api-version-provider");
var env_variables_protocol_1 = require("@theia/core/lib/common/env-variables/env-variables-protocol");
var expect = chai.expect;
describe('VSX Registry API', function () {
    var api;
    beforeEach(function () {
        var container = new inversify_1.Container();
        container.bind(vsx_registry_api_1.VSXRegistryAPI).toSelf().inSingletonScope();
        container.bind(vsx_environment_1.VSXEnvironment).toConstantValue({
            getRegistryApiUri: function () {
                return __awaiter(this, void 0, void 0, function () {
                    return __generator(this, function (_a) {
                        return [2 /*return*/, new uri_1.default('https://open-vsx.org/api')];
                    });
                });
            },
            getRegistryUri: function () {
                return __awaiter(this, void 0, void 0, function () {
                    return __generator(this, function (_a) {
                        return [2 /*return*/, new uri_1.default('https://open-vsx.org')];
                    });
                });
            },
            getVscodeApiVersion: function () {
                return __awaiter(this, void 0, void 0, function () {
                    return __generator(this, function (_a) {
                        return [2 /*return*/, '1.40.0'];
                    });
                });
            }
        });
        container.bind(env_variables_protocol_1.EnvVariablesServer).toConstantValue({});
        container.bind(vsx_api_version_provider_1.VSXApiVersionProvider).toConstantValue({
            getApiVersion: function () {
                return '1.40.0';
            }
        });
        api = container.get(vsx_registry_api_1.VSXRegistryAPI);
    });
    describe('isEngineValid', function () {
        it('should return \'true\' for a compatible engine', function () {
            var a = api['isEngineSupported']('^1.20.0');
            var b = api['isEngineSupported']('^1.40.0');
            expect(a).to.eq(true);
            expect(b).to.eq(true);
        });
        it('should return \'false\' for a incompatible engine', function () {
            var valid = api['isEngineSupported']('^1.50.0');
            expect(valid).to.eq(false);
        });
        it('should return \'false\' for an undefined engine', function () {
            var valid = api['isEngineSupported']();
            expect(valid).to.eq(false);
        });
    });
    describe('#buildSearchUri', function () {
        it('should correctly build the search URI with the single `query` parameter present', function () { return __awaiter(void 0, void 0, void 0, function () {
            var expected, param, query;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        expected = 'https://open-vsx.org/api/-/search?query=javascript';
                        param = {
                            query: 'javascript',
                        };
                        return [4 /*yield*/, api['buildSearchUri'](param)];
                    case 1:
                        query = _a.sent();
                        expect(query).to.eq(expected);
                        return [2 /*return*/];
                }
            });
        }); });
        it('should correctly build the search URI with the multiple search parameters present', function () { return __awaiter(void 0, void 0, void 0, function () {
            var expected, param, query;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        expected = 'https://open-vsx.org/api/-/search?query=javascript&category=languages&size=20&offset=10&includeAllVersions=true';
                        param = {
                            query: 'javascript',
                            category: 'languages',
                            size: 20,
                            offset: 10,
                            includeAllVersions: true,
                        };
                        return [4 /*yield*/, api['buildSearchUri'](param)];
                    case 1:
                        query = _a.sent();
                        expect(query).to.eq(expected);
                        expected = 'https://open-vsx.org/api/-/search?query=javascript&category=languages&size=20&offset=10&sortOrder=desc&sortBy=relevance&includeAllVersions=true';
                        param = {
                            query: 'javascript',
                            category: 'languages',
                            size: 20,
                            offset: 10,
                            sortOrder: 'desc',
                            sortBy: 'relevance',
                            includeAllVersions: true
                        };
                        return [4 /*yield*/, api['buildSearchUri'](param)];
                    case 2:
                        query = _a.sent();
                        expect(query).to.eq(expected);
                        return [2 /*return*/];
                }
            });
        }); });
    });
    describe('#buildSearchUri', function () {
        it('should correctly build the search URI with the single `query` parameter present', function () { return __awaiter(void 0, void 0, void 0, function () {
            return __generator(this, function (_a) {
                it('should build a proper query with the single `query` parameter present', function () { return __awaiter(void 0, void 0, void 0, function () {
                    var expected, param, query;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                expected = 'https://open-vsx.org/api/-/search?query=javascript';
                                param = {
                                    query: 'javascript',
                                };
                                return [4 /*yield*/, api['buildSearchUri'](param)];
                            case 1:
                                query = _a.sent();
                                expect(query).to.eq(expected);
                                return [2 /*return*/];
                        }
                    });
                }); });
                it('should correctly build the search URI with the multiple search parameters present', function () { return __awaiter(void 0, void 0, void 0, function () {
                    var expected, param, query;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                expected = 'https://open-vsx.org/api/-/search?query=javascript&category=languages&size=20&offset=10&includeAllVersions=true';
                                param = {
                                    query: 'javascript',
                                    category: 'languages',
                                    size: 20,
                                    offset: 10,
                                    includeAllVersions: true,
                                };
                                return [4 /*yield*/, api['buildSearchUri'](param)];
                            case 1:
                                query = _a.sent();
                                expect(query).to.eq(expected);
                                expected = 'https://open-vsx.org/api/-/search?query=javascript&category=languages&size=20&offset=10&sortOrder=desc&sortBy=relevance&includeAllVersions=true';
                                param = {
                                    query: 'javascript',
                                    category: 'languages',
                                    size: 20,
                                    offset: 10,
                                    sortOrder: 'desc',
                                    sortBy: 'relevance',
                                    includeAllVersions: true
                                };
                                return [4 /*yield*/, api['buildSearchUri'](param)];
                            case 2:
                                query = _a.sent();
                                expect(query).to.eq(expected);
                                return [2 /*return*/];
                        }
                    });
                }); });
                return [2 /*return*/];
            });
        }); });
    });
});
//# sourceMappingURL=vsx-registry-api.spec.js.map