"use strict";
/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FrontendGenerator = void 0;
/* eslint-disable @typescript-eslint/indent */
var abstract_generator_1 = require("./abstract-generator");
var fs_1 = require("fs");
var FrontendGenerator = /** @class */ (function (_super) {
    __extends(FrontendGenerator, _super);
    function FrontendGenerator() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    FrontendGenerator.prototype.generate = function () {
        return __awaiter(this, void 0, void 0, function () {
            var frontendModules, electronMainModules;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        frontendModules = this.pck.targetFrontendModules;
                        return [4 /*yield*/, this.write(this.pck.frontend('index.html'), this.compileIndexHtml(frontendModules))];
                    case 1:
                        _a.sent();
                        return [4 /*yield*/, this.write(this.pck.frontend('index.js'), this.compileIndexJs(frontendModules))];
                    case 2:
                        _a.sent();
                        if (!this.pck.isElectron()) return [3 /*break*/, 4];
                        electronMainModules = this.pck.targetElectronMainModules;
                        return [4 /*yield*/, this.write(this.pck.frontend('electron-main.js'), this.compileElectronMain(electronMainModules))];
                    case 3:
                        _a.sent();
                        _a.label = 4;
                    case 4: return [2 /*return*/];
                }
            });
        });
    };
    FrontendGenerator.prototype.compileIndexPreload = function (frontendModules) {
        var template = this.pck.props.generator.config.preloadTemplate;
        if (!template) {
            return '';
        }
        // Support path to html file
        if (fs_1.existsSync(template)) {
            return fs_1.readFileSync(template).toString();
        }
        return template;
    };
    FrontendGenerator.prototype.compileIndexHtml = function (frontendModules) {
        return "<!DOCTYPE html>\n<html lang=\"en\">\n\n<head>" + this.compileIndexHead(frontendModules) + "\n  <script type=\"text/javascript\" src=\"./bundle.js\" charset=\"utf-8\"></script>\n</head>\n\n<body>\n  <div class=\"theia-preload\">" + this.compileIndexPreload(frontendModules) + "</div>\n</body>\n\n</html>";
    };
    FrontendGenerator.prototype.compileIndexHead = function (frontendModules) {
        return "\n  <meta charset=\"UTF-8\">\n  <meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">\n  <meta name=\"apple-mobile-web-app-capable\" content=\"yes\">";
    };
    FrontendGenerator.prototype.compileIndexJs = function (frontendModules) {
        return "// @ts-check\n" + this.ifBrowser("require('es6-promise/auto');") + "\nrequire('reflect-metadata');\nrequire('setimmediate');\nconst { Container } = require('inversify');\nconst { FrontendApplicationConfigProvider } = require('@theia/core/lib/browser/frontend-application-config-provider');\nFrontendApplicationConfigProvider.set(" + this.prettyStringify(this.pck.props.frontend.config) + ");\nconst { FrontendApplication } = require('@theia/core/lib/browser');\nconst { frontendApplicationModule } = require('@theia/core/lib/browser/frontend-application-module');\nconst { messagingFrontendModule } = require('@theia/core/lib/" + (this.pck.isBrowser()
            ? 'browser/messaging/messaging-frontend-module'
            : 'electron-browser/messaging/electron-messaging-frontend-module') + "');\nconst { loggerFrontendModule } = require('@theia/core/lib/browser/logger-frontend-module');\nconst { ThemeService } = require('@theia/core/lib/browser/theming');\n\nconst container = new Container();\ncontainer.load(frontendApplicationModule);\ncontainer.load(messagingFrontendModule);\ncontainer.load(loggerFrontendModule);\n\nfunction load(raw) {\n    return Promise.resolve(raw.default).then(module =>\n        container.load(module)\n    )\n}\n\nfunction start() {\n    (window['theia'] = window['theia'] ||\u00A0{}).container = container;\n\n    const themeService = ThemeService.get();\n    themeService.loadUserTheme();\n\n    const application = container.get(FrontendApplication);\n    return application.start();\n}\n\nmodule.exports = Promise.resolve()" + this.compileFrontendModuleImports(frontendModules) + "\n    .then(start).catch(reason => {\n        console.error('Failed to start the frontend application.');\n        if (reason) {\n            console.error(reason);\n        }\n    });";
    };
    FrontendGenerator.prototype.compileElectronMain = function (electronMainModules) {
        return "// @ts-check\n\nrequire('reflect-metadata');\n\n// Useful for Electron/NW.js apps as GUI apps on macOS doesn't inherit the `$PATH` define\n// in your dotfiles (.bashrc/.bash_profile/.zshrc/etc).\n// https://github.com/electron/electron/issues/550#issuecomment-162037357\n// https://github.com/eclipse-theia/theia/pull/3534#issuecomment-439689082\nrequire('fix-path')();\n\n// Workaround for https://github.com/electron/electron/issues/9225. Chrome has an issue where\n// in certain locales (e.g. PL), image metrics are wrongly computed. We explicitly set the\n// LC_NUMERIC to prevent this from happening (selects the numeric formatting category of the\n// C locale, http://en.cppreference.com/w/cpp/locale/LC_categories).\nif (process.env.LC_ALL) {\n    process.env.LC_ALL = 'C';\n}\nprocess.env.LC_NUMERIC = 'C';\n\nconst { default: electronMainApplicationModule } = require('@theia/core/lib/electron-main/electron-main-application-module');\nconst { ElectronMainApplication, ElectronMainApplicationGlobals } = require('@theia/core/lib/electron-main/electron-main-application');\nconst { Container } = require('inversify');\nconst { resolve } = require('path');\nconst { app } = require('electron');\n\n// Fix the window reloading issue, see: https://github.com/electron/electron/issues/22119\napp.allowRendererProcessReuse = false;\n\nconst config = " + this.prettyStringify(this.pck.props.frontend.config) + ";\nconst isSingleInstance = " + (this.pck.props.backend.config.singleInstance === true ? 'true' : 'false') + ";\n\nif (isSingleInstance && !app.requestSingleInstanceLock()) {\n    // There is another instance running, exit now. The other instance will request focus.\n    app.quit();\n    return;\n}\n\nconst container = new Container();\ncontainer.load(electronMainApplicationModule);\ncontainer.bind(ElectronMainApplicationGlobals).toConstantValue({\n    THEIA_APP_PROJECT_PATH: resolve(__dirname, '..', '..'),\n    THEIA_BACKEND_MAIN_PATH: resolve(__dirname, '..', 'backend', 'main.js'),\n    THEIA_FRONTEND_HTML_PATH: resolve(__dirname, '..', '..', 'lib', 'index.html'),\n});\n\nfunction load(raw) {\n    return Promise.resolve(raw.default).then(module =>\n        container.load(module)\n    );\n}\n\nasync function start() {\n    const application = container.get(ElectronMainApplication);\n    await application.start(config);\n}\n\nmodule.exports = Promise.resolve()" + this.compileElectronMainModuleImports(electronMainModules) + "\n    .then(start).catch(reason => {\n        console.error('Failed to start the electron application.');\n        if (reason) {\n            console.error(reason);\n        }\n    });\n";
    };
    return FrontendGenerator;
}(abstract_generator_1.AbstractGenerator));
exports.FrontendGenerator = FrontendGenerator;
//# sourceMappingURL=frontend-generator.js.map