/********************************************************************************
 * Copyright (c) 2021 SAP SE or an SAP affiliate company and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
/// <reference types="@theia/monaco-editor-core/monaco" />
/// <reference types="react" />
import { TreeWidget, TreeProps, ContextMenuRenderer, TreeNode, TreeModel, NodeProps } from '@theia/core/lib/browser';
import * as React from '@theia/core/shared/react';
import { BulkEditInfoNode, BulkEditNode } from './bulk-edit-tree';
import { BulkEditTreeModel } from './bulk-edit-tree-model';
import { FileResourceResolver } from '@theia/filesystem/lib/browser';
import { EditorManager } from '@theia/editor/lib/browser';
import { QuickViewService } from '@theia/core/lib/browser/quick-view-service';
export declare const BULK_EDIT_TREE_WIDGET_ID = "bulkedit";
export declare const BULK_EDIT_WIDGET_NAME = "Refactor Preview";
export declare class BulkEditTreeWidget extends TreeWidget {
    readonly treeProps: TreeProps;
    readonly model: BulkEditTreeModel;
    readonly contextMenuRenderer: ContextMenuRenderer;
    private editorWidgets;
    protected readonly fileResourceResolver: FileResourceResolver;
    protected readonly editorManager: EditorManager;
    protected readonly quickView: QuickViewService;
    constructor(treeProps: TreeProps, model: BulkEditTreeModel, contextMenuRenderer: ContextMenuRenderer);
    initModel(workspaceEdit: monaco.languages.WorkspaceEdit): Promise<void>;
    protected handleClickEvent(node: TreeNode | undefined, event: React.MouseEvent<HTMLElement>): void;
    protected handleDown(event: KeyboardEvent): void;
    protected handleUp(event: KeyboardEvent): void;
    protected renderTree(model: TreeModel): React.ReactNode;
    protected renderCaption(node: TreeNode, props: NodeProps): React.ReactNode;
    protected decorateBulkEditNode(node: BulkEditNode): React.ReactNode;
    protected decorateBulkEditInfoNode(node: BulkEditInfoNode): React.ReactNode;
    private getFileContentsMap;
    private doOpen;
    private createReplacePreview;
    private getEditorOptions;
    private disposeEditors;
}
//# sourceMappingURL=bulk-edit-tree-widget.d.ts.map