"use strict";
/********************************************************************************
 * Copyright (c) 2021 SAP SE or an SAP affiliate company and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsdom_1 = require("@theia/core/lib/browser/test/jsdom");
var chai = require("chai");
var sinon = require("sinon");
var disableJSDOM = jsdom_1.enableJSDOM();
var frontend_application_config_provider_1 = require("@theia/core/lib/browser/frontend-application-config-provider");
var application_props_1 = require("@theia/application-package/lib/application-props");
frontend_application_config_provider_1.FrontendApplicationConfigProvider.set(__assign({}, application_props_1.ApplicationProps.DEFAULT.frontend.config));
var inversify_1 = require("@theia/core/shared/inversify");
var bulk_edit_tree_1 = require("./bulk-edit-tree");
global.monaco = sinon.stub();
global.monaco.Uri = sinon.stub();
global.monaco.Uri.isUri = sinon.stub().returns(true);
var expect = chai.expect;
var bulkEditTree;
var testContainer;
var fileContextsMap = new Map();
var workspaceEdit;
disableJSDOM();
before(function () {
    disableJSDOM = jsdom_1.enableJSDOM();
    testContainer = new inversify_1.Container();
    testContainer.bind(bulk_edit_tree_1.BulkEditTree).toSelf();
    bulkEditTree = testContainer.get(bulk_edit_tree_1.BulkEditTree);
    fileContextsMap.set('/c:/test1.ts', 'aaaaaaaaaaaaaaaaaaa');
    fileContextsMap.set('/c:/test2.ts', 'bbbbbbbbbbbbbbbbbbb');
    workspaceEdit = {
        'edits': [
            {
                'resource': {
                    '$mid': 1,
                    'path': '/c:/test1.ts',
                    'scheme': 'file'
                },
                'edit': {
                    'text': 'AAAAA', 'range': { 'startLineNumber': 1, 'startColumn': 5, 'endLineNumber': 1, 'endColumn': 10 }
                }
            },
            {
                'resource': {
                    '$mid': 1,
                    'path': '/c:/test2.ts',
                    'scheme': 'file'
                }, 'edit': {
                    'text': 'BBBBBB', 'range': { 'startLineNumber': 1, 'startColumn': 3, 'endLineNumber': 1, 'endColumn': 8 }
                }
            }
        ]
    };
});
after(function () {
    disableJSDOM();
});
describe('bulk-edit-tree', function () {
    it('initialize tree', function () {
        bulkEditTree.initTree(workspaceEdit, fileContextsMap);
        expect(bulkEditTree.root.children.length).is.equal(2);
    });
});
//# sourceMappingURL=bulk-edit-tree.spec.js.map