"use strict";
/********************************************************************************
 * Copyright (C) 2018 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsdom_1 = require("../browser/test/jsdom");
var disableJSDOM = jsdom_1.enableJSDOM();
var frontend_application_config_provider_1 = require("./frontend-application-config-provider");
var application_props_1 = require("@theia/application-package/lib/application-props");
frontend_application_config_provider_1.FrontendApplicationConfigProvider.set(__assign({}, application_props_1.ApplicationProps.DEFAULT.frontend.config));
var chai_1 = require("chai");
var connection_status_service_1 = require("./connection-status-service");
var mock_connection_status_service_1 = require("./test/mock-connection-status-service");
var sinon = require("sinon");
var inversify_1 = require("inversify");
var ws_connection_provider_1 = require("./messaging/ws-connection-provider");
var common_1 = require("../common");
disableJSDOM();
describe('connection-status', function () {
    var _this = this;
    var connectionStatusService;
    before(function () {
        disableJSDOM = jsdom_1.enableJSDOM();
    });
    after(function () {
        disableJSDOM();
    });
    beforeEach(function () {
        connectionStatusService = new mock_connection_status_service_1.MockConnectionStatusService();
    });
    afterEach(function () {
        if (connectionStatusService !== undefined) {
            connectionStatusService.dispose();
        }
    });
    it('should go from online to offline if the connection is down', function () { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    chai_1.expect(connectionStatusService.currentStatus).to.be.equal(connection_status_service_1.ConnectionStatus.ONLINE);
                    connectionStatusService.alive = false;
                    return [4 /*yield*/, pause()];
                case 1:
                    _a.sent();
                    chai_1.expect(connectionStatusService.currentStatus).to.be.equal(connection_status_service_1.ConnectionStatus.OFFLINE);
                    return [2 /*return*/];
            }
        });
    }); });
    it('should go from offline to online if the connection is re-established', function () { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    chai_1.expect(connectionStatusService.currentStatus).to.be.equal(connection_status_service_1.ConnectionStatus.ONLINE);
                    connectionStatusService.alive = false;
                    return [4 /*yield*/, pause()];
                case 1:
                    _a.sent();
                    chai_1.expect(connectionStatusService.currentStatus).to.be.equal(connection_status_service_1.ConnectionStatus.OFFLINE);
                    connectionStatusService.alive = true;
                    return [4 /*yield*/, pause()];
                case 2:
                    _a.sent();
                    chai_1.expect(connectionStatusService.currentStatus).to.be.equal(connection_status_service_1.ConnectionStatus.ONLINE);
                    return [2 /*return*/];
            }
        });
    }); });
});
describe('frontend-connection-status', function () {
    var OFFLINE_TIMEOUT = 10;
    var testContainer;
    var mockSocketOpenedEmitter = new common_1.Emitter();
    var mockSocketClosedEmitter = new common_1.Emitter();
    var mockIncomingMessageActivityEmitter = new common_1.Emitter();
    before(function () {
        disableJSDOM = jsdom_1.enableJSDOM();
    });
    after(function () {
        disableJSDOM();
    });
    var timer;
    var pingSpy;
    beforeEach(function () {
        var mockWebSocketConnectionProvider = sinon.createStubInstance(ws_connection_provider_1.WebSocketConnectionProvider);
        var mockPingService = {
            ping: function () {
                return Promise.resolve(undefined);
            }
        };
        var mockILogger = {
            error: function (loggable) {
                return Promise.resolve(undefined);
            }
        };
        testContainer = new inversify_1.Container();
        testContainer.bind(connection_status_service_1.FrontendConnectionStatusService).toSelf().inSingletonScope();
        testContainer.bind(connection_status_service_1.PingService).toConstantValue(mockPingService);
        testContainer.bind(common_1.ILogger).toConstantValue(mockILogger);
        testContainer.bind(connection_status_service_1.ConnectionStatusOptions).toConstantValue({ offlineTimeout: OFFLINE_TIMEOUT });
        testContainer.bind(ws_connection_provider_1.WebSocketConnectionProvider).toConstantValue(mockWebSocketConnectionProvider);
        sinon.stub(mockWebSocketConnectionProvider, 'onSocketDidOpen').value(mockSocketOpenedEmitter.event);
        sinon.stub(mockWebSocketConnectionProvider, 'onSocketDidClose').value(mockSocketClosedEmitter.event);
        sinon.stub(mockWebSocketConnectionProvider, 'onIncomingMessageActivity').value(mockIncomingMessageActivityEmitter.event);
        timer = sinon.useFakeTimers();
        pingSpy = sinon.spy(mockPingService, 'ping');
    });
    afterEach(function () {
        pingSpy.restore();
        timer.restore();
        testContainer.unbindAll();
    });
    it('should switch status to offline on websocket close', function () {
        var frontendConnectionStatusService = testContainer.get(connection_status_service_1.FrontendConnectionStatusService);
        frontendConnectionStatusService['init']();
        chai_1.expect(frontendConnectionStatusService.currentStatus).to.be.equal(connection_status_service_1.ConnectionStatus.ONLINE);
        mockSocketClosedEmitter.fire(undefined);
        chai_1.expect(frontendConnectionStatusService.currentStatus).to.be.equal(connection_status_service_1.ConnectionStatus.OFFLINE);
    });
    it('should switch status to online on websocket established', function () {
        var frontendConnectionStatusService = testContainer.get(connection_status_service_1.FrontendConnectionStatusService);
        frontendConnectionStatusService['init']();
        mockSocketClosedEmitter.fire(undefined);
        chai_1.expect(frontendConnectionStatusService.currentStatus).to.be.equal(connection_status_service_1.ConnectionStatus.OFFLINE);
        mockSocketOpenedEmitter.fire(undefined);
        chai_1.expect(frontendConnectionStatusService.currentStatus).to.be.equal(connection_status_service_1.ConnectionStatus.ONLINE);
    });
    it('should switch status to online on any websocket activity', function () {
        var frontendConnectionStatusService = testContainer.get(connection_status_service_1.FrontendConnectionStatusService);
        frontendConnectionStatusService['init']();
        mockSocketClosedEmitter.fire(undefined);
        chai_1.expect(frontendConnectionStatusService.currentStatus).to.be.equal(connection_status_service_1.ConnectionStatus.OFFLINE);
        mockIncomingMessageActivityEmitter.fire(undefined);
        chai_1.expect(frontendConnectionStatusService.currentStatus).to.be.equal(connection_status_service_1.ConnectionStatus.ONLINE);
    });
    it('should perform ping request after socket activity', function () {
        var frontendConnectionStatusService = testContainer.get(connection_status_service_1.FrontendConnectionStatusService);
        frontendConnectionStatusService['init']();
        mockIncomingMessageActivityEmitter.fire(undefined);
        chai_1.expect(frontendConnectionStatusService.currentStatus).to.be.equal(connection_status_service_1.ConnectionStatus.ONLINE);
        sinon.assert.notCalled(pingSpy);
        timer.tick(OFFLINE_TIMEOUT);
        sinon.assert.calledOnce(pingSpy);
    });
    it('should not perform ping request before desired timeout', function () {
        var frontendConnectionStatusService = testContainer.get(connection_status_service_1.FrontendConnectionStatusService);
        frontendConnectionStatusService['init']();
        mockIncomingMessageActivityEmitter.fire(undefined);
        chai_1.expect(frontendConnectionStatusService.currentStatus).to.be.equal(connection_status_service_1.ConnectionStatus.ONLINE);
        sinon.assert.notCalled(pingSpy);
        timer.tick(OFFLINE_TIMEOUT - 1);
        sinon.assert.notCalled(pingSpy);
    });
    it('should switch to offline mode if ping request was rejected', function () {
        var pingService = testContainer.get(connection_status_service_1.PingService);
        pingSpy.restore();
        var stub = sinon.stub(pingService, 'ping').onFirstCall().throws('failed to make a ping request');
        var frontendConnectionStatusService = testContainer.get(connection_status_service_1.FrontendConnectionStatusService);
        frontendConnectionStatusService['init']();
        mockIncomingMessageActivityEmitter.fire(undefined);
        chai_1.expect(frontendConnectionStatusService.currentStatus).to.be.equal(connection_status_service_1.ConnectionStatus.ONLINE);
        timer.tick(OFFLINE_TIMEOUT);
        sinon.assert.calledOnce(stub);
        chai_1.expect(frontendConnectionStatusService.currentStatus).to.be.equal(connection_status_service_1.ConnectionStatus.OFFLINE);
    });
});
function pause(time) {
    if (time === void 0) { time = 1; }
    return new Promise(function (resolve) { return setTimeout(resolve, time); });
}
//# sourceMappingURL=connection-status-service.spec.js.map