"use strict";
/********************************************************************************
 * Copyright (C) 2018 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
/* eslint-disable @typescript-eslint/no-explicit-any */
/* eslint-disable no-unused-expressions */
var jsdom_1 = require("../test/jsdom");
var disableJSDOM = jsdom_1.enableJSDOM();
var assert = require("assert");
var inversify_1 = require("inversify");
var frontend_application_bindings_1 = require("../frontend-application-bindings");
var test_1 = require("./test");
var preference_service_1 = require("./preference-service");
var preference_contribution_1 = require("./preference-contribution");
var preference_scope_1 = require("./preference-scope");
var preference_provider_1 = require("./preference-provider");
var frontend_application_config_provider_1 = require("../frontend-application-config-provider");
var preference_proxy_1 = require("./preference-proxy");
var application_props_1 = require("@theia/application-package/lib/application-props");
disableJSDOM();
process.on('unhandledRejection', function (reason, promise) {
    console.error(reason);
    throw reason;
});
var expect = require('chai').expect;
var testContainer;
function createTestContainer() {
    var result = new inversify_1.Container();
    frontend_application_bindings_1.bindPreferenceService(result.bind.bind(result));
    test_1.bindMockPreferenceProviders(result.bind.bind(result), result.unbind.bind(result));
    return result;
}
describe('Preference Proxy', function () {
    var prefService;
    var prefSchema;
    before(function () {
        disableJSDOM = jsdom_1.enableJSDOM();
        frontend_application_config_provider_1.FrontendApplicationConfigProvider.set(__assign(__assign({}, application_props_1.ApplicationProps.DEFAULT.frontend.config), { 'applicationName': 'test' }));
    });
    after(function () {
        disableJSDOM();
    });
    beforeEach(function () { return __awaiter(void 0, void 0, void 0, function () {
        var e_1;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    testContainer = createTestContainer();
                    prefSchema = testContainer.get(preference_contribution_1.PreferenceSchemaProvider);
                    prefService = testContainer.get(preference_service_1.PreferenceService);
                    getProvider(preference_scope_1.PreferenceScope.User).markReady();
                    getProvider(preference_scope_1.PreferenceScope.Workspace).markReady();
                    getProvider(preference_scope_1.PreferenceScope.Folder).markReady();
                    _a.label = 1;
                case 1:
                    _a.trys.push([1, 3, , 4]);
                    return [4 /*yield*/, prefService.ready];
                case 2:
                    _a.sent();
                    return [3 /*break*/, 4];
                case 3:
                    e_1 = _a.sent();
                    console.error(e_1);
                    return [3 /*break*/, 4];
                case 4: return [2 /*return*/];
            }
        });
    }); });
    afterEach(function () {
    });
    // Actually run the test suite with different parameters:
    testPreferenceProxy('Synchronous Schema Definition', { asyncSchema: false });
    testPreferenceProxy('Asynchronous Schema Definition (1s delay)', { asyncSchema: true });
    function getProvider(scope) {
        return testContainer.getNamed(preference_provider_1.PreferenceProvider, scope);
    }
    function testPreferenceProxy(testDescription, testOptions) {
        var _this = this;
        describe(testDescription, function () {
            function getProxy(schema, options) {
                var s = schema || {
                    properties: {
                        'my.pref': {
                            type: 'string',
                            defaultValue: 'foo'
                        }
                    }
                };
                if (testOptions.asyncSchema) {
                    var promisedSchema = new Promise(function (resolve) { return setTimeout(function () {
                        prefSchema.setSchema(s);
                        resolve(s);
                    }, 1000); });
                    var proxy = preference_proxy_1.createPreferenceProxy(prefService, promisedSchema, options);
                    return { proxy: proxy, promisedSchema: promisedSchema };
                }
                else {
                    prefSchema.setSchema(s);
                    var proxy = preference_proxy_1.createPreferenceProxy(prefService, s, options);
                    return { proxy: proxy };
                }
            }
            if (testOptions.asyncSchema) {
                it('using the proxy before the schema is set should be no-op', function () { return __awaiter(_this, void 0, void 0, function () {
                    var _a, proxy, promisedSchema, changed;
                    return __generator(this, function (_b) {
                        switch (_b.label) {
                            case 0:
                                _a = getProxy(), proxy = _a.proxy, promisedSchema = _a.promisedSchema;
                                changed = 0;
                                proxy.onPreferenceChanged(function (event) {
                                    changed += 1;
                                });
                                expect(proxy['my.pref']).to.equal(undefined);
                                expect(Object.keys(proxy).length).to.equal(0);
                                // The proxy doesn't know the schema, so events shouldn't be forwarded:
                                return [4 /*yield*/, getProvider(preference_scope_1.PreferenceScope.User).setPreference('my.pref', 'bar')];
                            case 1:
                                // The proxy doesn't know the schema, so events shouldn't be forwarded:
                                _b.sent();
                                expect(changed).to.equal(0);
                                expect(proxy['my.pref']).to.equal(undefined);
                                expect(Object.keys(proxy).length).to.equal(0);
                                // Once the schema is resolved, operations should be working:
                                return [4 /*yield*/, promisedSchema];
                            case 2:
                                // Once the schema is resolved, operations should be working:
                                _b.sent();
                                expect(proxy['my.pref']).to.equal('bar');
                                expect(Object.keys(proxy)).members(['my.pref']);
                                return [4 /*yield*/, getProvider(preference_scope_1.PreferenceScope.User).setPreference('my.pref', 'fizz')];
                            case 3:
                                _b.sent();
                                expect(changed).to.equal(1);
                                expect(proxy['my.pref']).to.equal('fizz');
                                return [2 /*return*/];
                        }
                    });
                }); });
            }
            it('by default, it should get provide access in flat style but not deep', function () { return __awaiter(_this, void 0, void 0, function () {
                var _a, proxy, promisedSchema;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            _a = getProxy(), proxy = _a.proxy, promisedSchema = _a.promisedSchema;
                            if (!promisedSchema) return [3 /*break*/, 2];
                            return [4 /*yield*/, promisedSchema];
                        case 1:
                            _b.sent();
                            _b.label = 2;
                        case 2:
                            expect(proxy['my.pref']).to.equal('foo');
                            expect(proxy.my).to.equal(undefined);
                            expect(Object.keys(proxy).join()).to.equal(['my.pref'].join());
                            return [2 /*return*/];
                    }
                });
            }); });
            it('it should get provide access in deep style but not flat', function () { return __awaiter(_this, void 0, void 0, function () {
                var _a, proxy, promisedSchema;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            _a = getProxy(undefined, { style: 'deep' }), proxy = _a.proxy, promisedSchema = _a.promisedSchema;
                            if (!promisedSchema) return [3 /*break*/, 2];
                            return [4 /*yield*/, promisedSchema];
                        case 1:
                            _b.sent();
                            _b.label = 2;
                        case 2:
                            expect(proxy['my.pref']).to.equal(undefined);
                            expect(proxy.my.pref).to.equal('foo');
                            expect(Object.keys(proxy).join()).to.equal(['my'].join());
                            return [2 /*return*/];
                    }
                });
            }); });
            it('it should get provide access in to both styles', function () { return __awaiter(_this, void 0, void 0, function () {
                var _a, proxy, promisedSchema;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            _a = getProxy(undefined, { style: 'both' }), proxy = _a.proxy, promisedSchema = _a.promisedSchema;
                            if (!promisedSchema) return [3 /*break*/, 2];
                            return [4 /*yield*/, promisedSchema];
                        case 1:
                            _b.sent();
                            _b.label = 2;
                        case 2:
                            expect(proxy['my.pref']).to.equal('foo');
                            expect(proxy.my.pref).to.equal('foo');
                            expect(Object.keys(proxy).join()).to.equal(['my', 'my.pref'].join());
                            return [2 /*return*/];
                    }
                });
            }); });
            it('it should forward change events', function () { return __awaiter(_this, void 0, void 0, function () {
                var _a, proxy, promisedSchema, theChange, theSecondChange;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            _a = getProxy(undefined, { style: 'both' }), proxy = _a.proxy, promisedSchema = _a.promisedSchema;
                            if (!promisedSchema) return [3 /*break*/, 2];
                            return [4 /*yield*/, promisedSchema];
                        case 1:
                            _b.sent();
                            _b.label = 2;
                        case 2:
                            proxy.onPreferenceChanged(function (change) {
                                expect(theChange).to.equal(undefined);
                                theChange = change;
                            });
                            proxy.my.onPreferenceChanged(function (change) {
                                expect(theSecondChange).to.equal(undefined);
                                theSecondChange = change;
                            });
                            return [4 /*yield*/, getProvider(preference_scope_1.PreferenceScope.User).setPreference('my.pref', 'bar')];
                        case 3:
                            _b.sent();
                            expect(theChange.newValue).to.equal('bar');
                            expect(theChange.oldValue).to.equal(undefined);
                            expect(theChange.preferenceName).to.equal('my.pref');
                            expect(theSecondChange.newValue).to.equal('bar');
                            expect(theSecondChange.oldValue).to.equal(undefined);
                            expect(theSecondChange.preferenceName).to.equal('my.pref');
                            return [2 /*return*/];
                    }
                });
            }); });
            it('toJSON with deep', function () { return __awaiter(_this, void 0, void 0, function () {
                var _a, proxy, promisedSchema;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            _a = getProxy({
                                properties: {
                                    'foo.baz': {
                                        type: 'number',
                                        default: 4
                                    },
                                    'foo.bar.x': {
                                        type: 'boolean',
                                        default: true
                                    },
                                    'foo.bar.y': {
                                        type: 'boolean',
                                        default: false
                                    },
                                    'a': {
                                        type: 'string',
                                        default: 'a'
                                    }
                                }
                            }, { style: 'deep' }), proxy = _a.proxy, promisedSchema = _a.promisedSchema;
                            if (!promisedSchema) return [3 /*break*/, 2];
                            return [4 /*yield*/, promisedSchema];
                        case 1:
                            _b.sent();
                            _b.label = 2;
                        case 2:
                            assert.deepStrictEqual(JSON.stringify(proxy, undefined, 2), JSON.stringify({
                                foo: {
                                    baz: 4,
                                    bar: {
                                        x: true,
                                        y: false
                                    }
                                },
                                a: 'a'
                            }, undefined, 2), 'there should not be foo.bar.x to avoid sending excessive data to remote clients');
                            return [2 /*return*/];
                    }
                });
            }); });
            it('get nested default', function () { return __awaiter(_this, void 0, void 0, function () {
                var _a, proxy, promisedSchema;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            _a = getProxy({
                                properties: {
                                    'foo': {
                                        'anyOf': [
                                            {
                                                'enum': [
                                                    false
                                                ]
                                            },
                                            {
                                                'properties': {
                                                    'bar': {
                                                        'anyOf': [
                                                            {
                                                                'enum': [
                                                                    false
                                                                ]
                                                            },
                                                            {
                                                                'properties': {
                                                                    'x': {
                                                                        type: 'boolean'
                                                                    },
                                                                    'y': {
                                                                        type: 'boolean'
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    }
                                                }
                                            }
                                        ],
                                        default: {
                                            bar: {
                                                x: true,
                                                y: false
                                            }
                                        }
                                    }
                                }
                            }, { style: 'both' }), proxy = _a.proxy, promisedSchema = _a.promisedSchema;
                            if (!promisedSchema) return [3 /*break*/, 2];
                            return [4 /*yield*/, promisedSchema];
                        case 1:
                            _b.sent();
                            _b.label = 2;
                        case 2:
                            assert.deepStrictEqual(proxy['foo'], {
                                bar: {
                                    x: true,
                                    y: false
                                }
                            });
                            assert.deepStrictEqual(proxy['foo.bar'], {
                                x: true,
                                y: false
                            });
                            assert.strictEqual(proxy['foo.bar.x'], true);
                            assert.strictEqual(proxy['foo.bar.y'], false);
                            return [2 /*return*/];
                    }
                });
            }); });
        });
    }
});
//# sourceMappingURL=preference-proxy.spec.js.map