"use strict";
/********************************************************************************
 * Copyright (C) 2019 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var assert = require("assert");
var inversify_1 = require("inversify");
var tree_test_container_1 = require("./test/tree-test-container");
var tree_1 = require("./tree");
var tree_model_1 = require("./tree-model");
var tree_label_provider_1 = require("./tree-label-provider");
var ConsistencyTestTree = /** @class */ (function (_super) {
    __extends(ConsistencyTestTree, _super);
    function ConsistencyTestTree() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.resolveCounter = 0;
        return _this;
    }
    ConsistencyTestTree.prototype.resolveChildren = function (parent) {
        return __awaiter(this, void 0, void 0, function () {
            var step_1;
            var _this = this;
            return __generator(this, function (_a) {
                if (parent.id === 'expandable') {
                    step_1 = function () { return __awaiter(_this, void 0, void 0, function () {
                        return __generator(this, function (_a) {
                            switch (_a.label) {
                                case 0:
                                    if (!(this.root && this.root !== parent.parent)) return [3 /*break*/, 1];
                                    this.resolveCounter++;
                                    return [2 /*return*/, []];
                                case 1: return [4 /*yield*/, new Promise(function (resolve) { return setTimeout(resolve, 10); })];
                                case 2:
                                    _a.sent();
                                    return [2 /*return*/, step_1()];
                            }
                        });
                    }); };
                    return [2 /*return*/, step_1()];
                }
                return [2 /*return*/, _super.prototype.resolveChildren.call(this, parent)];
            });
        });
    };
    ConsistencyTestTree = __decorate([
        inversify_1.injectable()
    ], ConsistencyTestTree);
    return ConsistencyTestTree;
}(tree_1.TreeImpl));
/**
 * Return roots having the same id, but not object identity.
 */
function createConsistencyTestRoot(rootName) {
    var children = [];
    var root = {
        id: 'root',
        name: rootName,
        parent: undefined,
        children: children
    };
    var parent = {
        id: 'expandable',
        name: 'expandable',
        parent: root,
        expanded: true,
        children: []
    };
    children.push(parent);
    return root;
}
describe('Tree Consistency', function () {
    it('setting different tree roots should finish', function () { return __awaiter(void 0, void 0, void 0, function () {
        var container, labelProvider, tree, model, resolveCounter, i;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    container = tree_test_container_1.createTreeTestContainer();
                    container.bind(tree_label_provider_1.TreeLabelProvider).toSelf().inSingletonScope();
                    labelProvider = container.get(tree_label_provider_1.TreeLabelProvider);
                    container.bind(ConsistencyTestTree).toSelf();
                    container.rebind(tree_1.TreeImpl).toService(ConsistencyTestTree);
                    tree = container.get(ConsistencyTestTree);
                    model = container.get(tree_model_1.TreeModel);
                    model.root = createConsistencyTestRoot('Foo');
                    return [4 /*yield*/, new Promise(function (resolve) { return setTimeout(resolve, 50); })];
                case 1:
                    _a.sent();
                    model.root = createConsistencyTestRoot('Bar');
                    return [4 /*yield*/, new Promise(function (resolve) { return setTimeout(resolve, 50); })];
                case 2:
                    _a.sent();
                    resolveCounter = tree.resolveCounter;
                    assert.deepStrictEqual(tree.resolveCounter, 1);
                    i = 0;
                    _a.label = 3;
                case 3:
                    if (!(i < 10)) return [3 /*break*/, 6];
                    return [4 /*yield*/, new Promise(function (resolve) { return setTimeout(resolve, 50); })];
                case 4:
                    _a.sent();
                    if (resolveCounter === tree.resolveCounter) {
                        assert.deepStrictEqual(tree.resolveCounter, 1);
                        assert.deepStrictEqual(labelProvider.getName(model.root), 'Bar');
                        return [2 /*return*/];
                    }
                    resolveCounter = tree.resolveCounter;
                    _a.label = 5;
                case 5:
                    i++;
                    return [3 /*break*/, 3];
                case 6:
                    assert.ok(false, 'Resolving does not stop, attempts: ' + tree.resolveCounter);
                    return [2 /*return*/];
            }
        });
    }); });
});
//# sourceMappingURL=tree-consistency.spec.js.map