"use strict";
/********************************************************************************
 * Copyright (C) 2018 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
var chai_1 = require("chai");
var event_1 = require("./event");
describe('Event Objects', function () {
    it('Emitter firing should be synchronous', function () {
        var emitter = new event_1.Emitter();
        var counter = 0;
        emitter.event(function () { return counter++; });
        chai_1.expect(counter).eq(0);
        emitter.fire(undefined);
        chai_1.expect(counter).eq(1);
    });
});
//# sourceMappingURL=event.spec.js.map