"use strict";
/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var assert = require("assert");
var path_1 = require("./path");
var chai_1 = require("chai");
describe('Path', function () {
    it('new from /foo/bar/file.txt', function () {
        var path = new path_1.Path('/foo/bar/file.txt');
        assert.deepStrictEqual(path.isRoot, false);
        assert.deepStrictEqual(path.isAbsolute, true);
        assert.deepStrictEqual(path.root.toString(), '/');
        assert.deepStrictEqual(path.dir.toString(), '/foo/bar');
        assert.deepStrictEqual(path.hasDir, true);
        assert.deepStrictEqual(path.base, 'file.txt');
        assert.deepStrictEqual(path.name, 'file');
        assert.deepStrictEqual(path.ext, '.txt');
    });
    it('new from foo/bar/file.txt', function () {
        var path = new path_1.Path('foo/bar/file.txt');
        assert.deepStrictEqual(path.isRoot, false);
        assert.deepStrictEqual(path.isAbsolute, false);
        assert.deepStrictEqual(path.root, undefined);
        assert.deepStrictEqual(path.dir.toString(), 'foo/bar');
        assert.deepStrictEqual(path.hasDir, true);
        assert.deepStrictEqual(path.base, 'file.txt');
        assert.deepStrictEqual(path.name, 'file');
        assert.deepStrictEqual(path.ext, '.txt');
    });
    it('new from /foo', function () {
        var path = new path_1.Path('/foo');
        assert.deepStrictEqual(path.isRoot, false);
        assert.deepStrictEqual(path.isAbsolute, true);
        assert.deepStrictEqual(path.root.toString(), '/');
        assert.deepStrictEqual(path.dir.toString(), '/');
        assert.deepStrictEqual(path.hasDir, true);
        assert.deepStrictEqual(path.base, 'foo');
        assert.deepStrictEqual(path.name, 'foo');
        assert.deepStrictEqual(path.ext, '');
    });
    it('new from foo', function () {
        var path = new path_1.Path('foo');
        assert.deepStrictEqual(path.isRoot, false);
        assert.deepStrictEqual(path.isAbsolute, false);
        assert.deepStrictEqual(path.root, undefined);
        assert.deepStrictEqual(path.dir.toString(), 'foo');
        assert.deepStrictEqual(path.hasDir, false);
        assert.deepStrictEqual(path.base, 'foo');
        assert.deepStrictEqual(path.name, 'foo');
        assert.deepStrictEqual(path.ext, '');
    });
    it('new from /', function () {
        var path = new path_1.Path('/');
        assert.deepStrictEqual(path.isRoot, true);
        assert.deepStrictEqual(path.isAbsolute, true);
        assert.deepStrictEqual(path.root.toString(), '/');
        assert.deepStrictEqual(path.dir.toString(), '/');
        assert.deepStrictEqual(path.hasDir, false);
        assert.deepStrictEqual(path.base, '');
        assert.deepStrictEqual(path.name, '');
        assert.deepStrictEqual(path.ext, '');
    });
    it('new from /c:/foo/bar/file.txt', function () {
        var path = new path_1.Path('/c:/foo/bar/file.txt');
        assert.deepStrictEqual(path.isRoot, false);
        assert.deepStrictEqual(path.isAbsolute, true);
        assert.deepStrictEqual(path.root.toString(), '/c:');
        assert.deepStrictEqual(path.dir.toString(), '/c:/foo/bar');
        assert.deepStrictEqual(path.hasDir, true);
        assert.deepStrictEqual(path.base, 'file.txt');
        assert.deepStrictEqual(path.name, 'file');
        assert.deepStrictEqual(path.ext, '.txt');
    });
    it('new from /c:/foo', function () {
        var path = new path_1.Path('/c:/foo');
        assert.deepStrictEqual(path.isRoot, false);
        assert.deepStrictEqual(path.isAbsolute, true);
        assert.deepStrictEqual(path.root.toString(), '/c:');
        assert.deepStrictEqual(path.dir.toString(), '/c:');
        assert.deepStrictEqual(path.hasDir, true);
        assert.deepStrictEqual(path.base, 'foo');
        assert.deepStrictEqual(path.name, 'foo');
        assert.deepStrictEqual(path.ext, '');
    });
    it('new from /c:/', function () {
        var path = new path_1.Path('/c:/');
        assert.deepStrictEqual(path.isRoot, false);
        assert.deepStrictEqual(path.isAbsolute, true);
        assert.deepStrictEqual(path.root.toString(), '/c:');
        assert.deepStrictEqual(path.dir.toString(), '/c:');
        assert.deepStrictEqual(path.hasDir, true);
        assert.deepStrictEqual(path.base, '');
        assert.deepStrictEqual(path.name, '');
        assert.deepStrictEqual(path.ext, '');
    });
    it('new from /c:', function () {
        var path = new path_1.Path('/c:');
        assert.deepStrictEqual(path.isRoot, true);
        assert.deepStrictEqual(path.isAbsolute, true);
        assert.deepStrictEqual(path.root.toString(), '/c:');
        assert.deepStrictEqual(path.dir.toString(), '/c:');
        assert.deepStrictEqual(path.hasDir, false);
        assert.deepStrictEqual(path.base, 'c:');
        assert.deepStrictEqual(path.name, 'c:');
        assert.deepStrictEqual(path.ext, '');
    });
    assertRelative({
        from: '/foo',
        to: '/foo',
        expectation: ''
    });
    assertRelative({
        from: '/foo',
        to: '/foo/bar',
        expectation: 'bar'
    });
    assertRelative({
        from: '/foo/',
        to: '/foo/bar',
        expectation: 'bar'
    });
    assertRelative({
        from: '/f',
        to: '/foo/bar',
        expectation: undefined
    });
    function assertRelative(_a) {
        var from = _a.from, to = _a.to, expectation = _a.expectation;
        it("the relative path from '" + from + "' to '" + to + "' should be '" + expectation + "'", function () {
            var path = new path_1.Path(from).relative(new path_1.Path(to));
            assert.deepStrictEqual(expectation, path && path.toString());
        });
    }
    assertNormalize({
        from: '/',
        expectation: '/'
    });
    assertNormalize({
        from: '/c://',
        expectation: '/c:/'
    });
    assertNormalize({
        from: '/foo',
        expectation: '/foo'
    });
    assertNormalize({
        from: '/foo/',
        expectation: '/foo/'
    });
    assertNormalize({
        from: '/foo/bar',
        expectation: '/foo/bar'
    });
    assertNormalize({
        from: '/foo/../file.txt',
        expectation: '/file.txt'
    });
    assertNormalize({
        from: '/foo/bar/../file.txt',
        expectation: '/foo/file.txt'
    });
    assertNormalize({
        from: '/foo/../../file.txt',
        expectation: '/file.txt'
    });
    assertNormalize({
        from: '',
        expectation: '.'
    });
    assertNormalize({
        from: '.',
        expectation: '.'
    });
    assertNormalize({
        from: '..',
        expectation: '..'
    });
    assertNormalize({
        from: './foo',
        expectation: 'foo'
    });
    assertNormalize({
        from: './foo/./.',
        expectation: 'foo'
    });
    assertNormalize({
        from: './foo/',
        expectation: 'foo/'
    });
    assertNormalize({
        from: '../foo',
        expectation: '../foo'
    });
    assertNormalize({
        from: 'foo/..',
        expectation: '.'
    });
    assertNormalize({
        from: 'foo/bar/../../../',
        expectation: '../'
    });
    function assertNormalize(_a) {
        var from = _a.from, expectation = _a.expectation;
        it("path " + from + " should be normalized as " + expectation, function () {
            assert.deepStrictEqual(new path_1.Path(from).normalize().toString(), expectation);
        });
    }
    var linuxHome = '/home/test-user';
    var windowsHome = '/C:/Users/test-user';
    describe('Linux', function () {
        it('should shorten path on Linux, path starting with home', function () { return __awaiter(void 0, void 0, void 0, function () {
            var path, expected;
            return __generator(this, function (_a) {
                path = linuxHome + "/a/b/theia";
                expected = '~/a/b/theia';
                chai_1.expect(path_1.Path.tildify(path, linuxHome)).eq(expected);
                return [2 /*return*/];
            });
        }); });
        it('should shorten path on Linux, path starting with home with duplication', function () { return __awaiter(void 0, void 0, void 0, function () {
            var path, expected;
            return __generator(this, function (_a) {
                path = linuxHome + "/" + linuxHome + "/a/b/theia";
                expected = "~/" + linuxHome + "/a/b/theia";
                chai_1.expect(path_1.Path.tildify(path, linuxHome)).eq(expected);
                return [2 /*return*/];
            });
        }); });
        it('should not shorten path on Linux, path not starting with home', function () { return __awaiter(void 0, void 0, void 0, function () {
            var path, expected;
            return __generator(this, function (_a) {
                path = "/test/" + linuxHome + "/a/b/theia";
                expected = "/test/" + linuxHome + "/a/b/theia";
                chai_1.expect(path_1.Path.tildify(path, linuxHome)).eq(expected);
                return [2 /*return*/];
            });
        }); });
        it('should not shorten path on Linux, path not starting with correct home', function () { return __awaiter(void 0, void 0, void 0, function () {
            var path, expected;
            return __generator(this, function (_a) {
                path = "/test/" + linuxHome + "123/a/b/theia";
                expected = "/test/" + linuxHome + "123/a/b/theia";
                chai_1.expect(path_1.Path.tildify(path, linuxHome)).eq(expected);
                return [2 /*return*/];
            });
        }); });
        it('should not shorten path on Linux when home is empty', function () { return __awaiter(void 0, void 0, void 0, function () {
            var path, expected;
            return __generator(this, function (_a) {
                path = linuxHome + "/a/b/theia";
                expected = linuxHome + "/a/b/theia";
                chai_1.expect(path_1.Path.tildify(path, '')).eq(expected);
                return [2 /*return*/];
            });
        }); });
    });
    describe('Windows', function () {
        it('should not shorten path on Windows', function () { return __awaiter(void 0, void 0, void 0, function () {
            var path, expected;
            return __generator(this, function (_a) {
                path = windowsHome + "/a/b/theia";
                expected = windowsHome + "/a/b/theia";
                chai_1.expect(path_1.Path.tildify(path, windowsHome)).eq(expected);
                return [2 /*return*/];
            });
        }); });
        it('should not shorten path on Windows when home is empty', function () { return __awaiter(void 0, void 0, void 0, function () {
            var path, expected;
            return __generator(this, function (_a) {
                path = windowsHome + "/a/b/theia";
                expected = windowsHome + "/a/b/theia";
                chai_1.expect(path_1.Path.tildify(path, '')).eq(expected);
                return [2 /*return*/];
            });
        }); });
    });
});
//# sourceMappingURL=path.spec.js.map