"use strict";
/********************************************************************************
 * Copyright (C) 2020 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var chai = require("chai");
var uri_1 = require("./uri");
var uri_command_handler_1 = require("./uri-command-handler");
var expect = chai.expect;
var mockHandler = {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    execute: function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        this.lastCall = args;
    },
    lastCall: []
};
var selectedURIs = [
    new uri_1.default('/foo'),
    new uri_1.default('/bar'),
];
var mockSelectionService = {
    selection: selectedURIs.map(function (uri) { return ({ uri: uri }); })
};
describe('URI-Aware Command Handlers', function () {
    afterEach(function () {
        mockHandler.lastCall = [];
    });
    describe('UriAwareCommandHandler', function () {
        it('getUri returns the first argument if it is a URI (single)', function () {
            var _a;
            var args = [new uri_1.default('/passed/in'), 'some', 'other', 'args'];
            var output = (_a = uri_command_handler_1.UriAwareCommandHandler.MonoSelect(mockSelectionService, mockHandler))['getUri'].apply(_a, __spread(args));
            expect(output).equals(args[0]);
        });
        it('getUri returns the first argument if it is a URI (multi)', function () {
            var _a;
            var args = [[new uri_1.default('/passed/in')], 'some', 'other', 'args'];
            var output = (_a = uri_command_handler_1.UriAwareCommandHandler.MultiSelect(mockSelectionService, mockHandler))['getUri'].apply(_a, __spread(args));
            expect(output).equals(args[0]);
        });
        it('getUri returns an argument from the service if no URI is provided (single)', function () {
            var _a;
            var args = ['some', 'other', 'args'];
            var output = (_a = uri_command_handler_1.UriAwareCommandHandler.MonoSelect(mockSelectionService, mockHandler))['getUri'].apply(_a, __spread(args));
            expect(output).equals(selectedURIs[0]);
        });
        it('getUri returns an argument from the service if no URI is provided (multi)', function () {
            var _a;
            var args = ['some', 'other', 'args'];
            var output = (_a = uri_command_handler_1.UriAwareCommandHandler.MultiSelect(mockSelectionService, mockHandler))['getUri'].apply(_a, __spread(args));
            expect(output).deep.equals(selectedURIs);
        });
        it('calls the handler with the same args if the first argument if it is a URI (single)', function () {
            var _a;
            var args = [new uri_1.default('/passed/in'), 'some', 'other', 'args'];
            (_a = uri_command_handler_1.UriAwareCommandHandler.MonoSelect(mockSelectionService, mockHandler))['execute'].apply(_a, __spread(args));
            expect(mockHandler.lastCall).deep.equals(args);
        });
        it('calls the handler with the same args if the first argument if it is a URI (multi)', function () {
            var _a;
            var args = [[new uri_1.default('/passed/in')], 'some', 'other', 'args'];
            (_a = uri_command_handler_1.UriAwareCommandHandler.MultiSelect(mockSelectionService, mockHandler))['execute'].apply(_a, __spread(args));
            expect(mockHandler.lastCall).deep.equals(args);
        });
        it('calls the handler with an argument from the service if no URI is provided (single)', function () {
            var _a;
            var args = ['some', 'other', 'args'];
            (_a = uri_command_handler_1.UriAwareCommandHandler.MonoSelect(mockSelectionService, mockHandler))['execute'].apply(_a, __spread(args));
            expect(mockHandler.lastCall).deep.equals(__spread([selectedURIs[0]], args));
        });
        it('calls the handler with an argument from the service if no URI is provided (multi)', function () {
            var _a;
            var args = ['some', 'other', 'args'];
            (_a = uri_command_handler_1.UriAwareCommandHandler.MultiSelect(mockSelectionService, mockHandler))['execute'].apply(_a, __spread(args));
            expect(mockHandler.lastCall).deep.equals(__spread([selectedURIs], args));
        });
    });
});
//# sourceMappingURL=uri-command-handler.spec.js.map