"use strict";
/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var yargs = require("yargs");
var chai = require("chai");
var cli_1 = require("./cli");
var promise_util_1 = require("../common/promise-util");
var TestCliManager = /** @class */ (function (_super) {
    __extends(TestCliManager, _super);
    function TestCliManager() {
        var contribs = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            contribs[_i] = arguments[_i];
        }
        return _super.call(this, {
            getContributions: function () { return contribs; }
        }) || this;
    }
    return TestCliManager;
}(cli_1.CliManager));
beforeEach(function () {
    yargs.global([]);
});
describe('CliManager', function () {
    it('Parses simple option', function () { return __awaiter(void 0, void 0, void 0, function () {
        var value, mnr, _a, _b;
        return __generator(this, function (_c) {
            switch (_c.label) {
                case 0:
                    value = new promise_util_1.Deferred();
                    mnr = new TestCliManager({
                        configure: function (conf) {
                            conf.option('foo', { alias: 'f', description: 'Some foo.' });
                            conf.option('bar', { alias: 'b', description: 'Some bla.', default: 'my-default', type: 'string' });
                        },
                        setArguments: function (args) {
                            value.resolve(args['foo']);
                        }
                    });
                    return [4 /*yield*/, mnr.initializeCli(['-f', 'bla'])];
                case 1:
                    _c.sent();
                    _b = (_a = chai.assert).equal;
                    return [4 /*yield*/, value.promise];
                case 2:
                    _b.apply(_a, [_c.sent(), 'bla']);
                    return [2 /*return*/];
            }
        });
    }); });
    it('resolves with default', function () { return __awaiter(void 0, void 0, void 0, function () {
        var value, mnr, _a, _b;
        return __generator(this, function (_c) {
            switch (_c.label) {
                case 0:
                    value = new promise_util_1.Deferred();
                    mnr = new TestCliManager({
                        configure: function (conf) {
                            conf.option('foo', { alias: 'f', description: 'Some foo.' });
                            conf.option('bar', { alias: 'b', description: 'Some bla.', default: 'my-default', type: 'string' });
                        },
                        setArguments: function (args) {
                            value.resolve(args['bar']);
                        }
                    });
                    return [4 /*yield*/, mnr.initializeCli(['--foo'])];
                case 1:
                    _c.sent();
                    _b = (_a = chai.assert).equal;
                    return [4 /*yield*/, value.promise];
                case 2:
                    _b.apply(_a, [_c.sent(), 'my-default']);
                    return [2 /*return*/];
            }
        });
    }); });
    it('prints help and exits', function () { return __awaiter(void 0, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2 /*return*/, assertExits(function () { return __awaiter(void 0, void 0, void 0, function () {
                    var mnr;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                mnr = new TestCliManager();
                                return [4 /*yield*/, mnr.initializeCli(['--help'])];
                            case 1:
                                _a.sent();
                                return [2 /*return*/];
                        }
                    });
                }); })];
        });
    }); });
});
function assertExits(code) {
    return __awaiter(this, void 0, void 0, function () {
        var oldExit, exitCalled, exitError, err_1;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    oldExit = process.exit;
                    exitCalled = new promise_util_1.Deferred();
                    exitError = new Error();
                    process.exit = function () {
                        throw exitError;
                    };
                    _a.label = 1;
                case 1:
                    _a.trys.push([1, 3, 4, 5]);
                    return [4 /*yield*/, code()];
                case 2:
                    _a.sent();
                    exitCalled.reject();
                    return [3 /*break*/, 5];
                case 3:
                    err_1 = _a.sent();
                    if (err_1 === exitError) {
                        exitCalled.resolve();
                    }
                    else {
                        exitCalled.reject();
                    }
                    return [3 /*break*/, 5];
                case 4:
                    process.exit = oldExit;
                    return [7 /*endfinally*/];
                case 5: return [2 /*return*/, exitCalled.promise];
            }
        });
    });
}
//# sourceMappingURL=cli.spec.js.map