"use strict";
/********************************************************************************
 * Copyright (C) 2018 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketChannelConnection = exports.MessagingService = void 0;
var web_socket_channel_1 = require("../../common/messaging/web-socket-channel");
var MessagingService;
(function (MessagingService) {
    /** Inversify container identifier for the `MessagingService` component. */
    MessagingService.Identifier = Symbol('MessagingService');
    MessagingService.Contribution = Symbol('MessagingService.Contribution');
})(MessagingService = exports.MessagingService || (exports.MessagingService = {}));
var WebSocketChannelConnection;
(function (WebSocketChannelConnection) {
    function is(connection) {
        return connection.channel instanceof web_socket_channel_1.WebSocketChannel;
    }
    WebSocketChannelConnection.is = is;
    function create(connection, channel) {
        var result = connection;
        result.channel = channel;
        return result;
    }
    WebSocketChannelConnection.create = create;
})(WebSocketChannelConnection = exports.WebSocketChannelConnection || (exports.WebSocketChannelConnection = {}));
//# sourceMappingURL=messaging-service.js.map