"use strict";
/********************************************************************************
 * Copyright (C) 2021 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LinuxExternalTerminalService = void 0;
var cp = require("child_process");
var fs = require("@theia/core/shared/fs-extra");
var inversify_1 = require("@theia/core/shared/inversify");
var os_1 = require("@theia/core/lib/common/os");
var file_uri_1 = require("@theia/core/lib/node/file-uri");
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
// some code copied and modified from https://github.com/microsoft/vscode/blob/1.52.1/src/vs/workbench/contrib/externalTerminal/node/externalTerminalService.ts
var LinuxExternalTerminalService = /** @class */ (function () {
    function LinuxExternalTerminalService() {
    }
    LinuxExternalTerminalService.prototype.openTerminal = function (configuration, cwd) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.spawnTerminal(configuration, file_uri_1.FileUri.fsPath(cwd))];
                    case 1:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    LinuxExternalTerminalService.prototype.getDefaultExec = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.getDefaultTerminalLinux()];
            });
        });
    };
    /**
     * Spawn the external terminal for the given options.
     * - The method spawns the terminal application based on the preferences, else uses the default value.
     * @param configuration the preference configuration.
     * @param cwd the optional current working directory to spawn from.
     */
    LinuxExternalTerminalService.prototype.spawnTerminal = function (configuration, cwd) {
        return __awaiter(this, void 0, void 0, function () {
            var terminalConfig, execPromise;
            return __generator(this, function (_a) {
                terminalConfig = configuration['terminal.external.linuxExec'];
                execPromise = terminalConfig ? Promise.resolve(terminalConfig) : this.getDefaultTerminalLinux();
                return [2 /*return*/, new Promise(function (resolve, reject) {
                        execPromise.then(function (exec) {
                            var env = cwd ? { cwd: cwd } : undefined;
                            var child = cp.spawn(exec, [], env);
                            child.on('error', reject);
                            child.on('exit', resolve);
                        });
                    })];
            });
        });
    };
    /**
     * Get the default terminal application on Linux.
     * - The following method uses environment variables to identify the best default possible for each distro.
     *
     * @returns the default application on Linux.
     */
    LinuxExternalTerminalService.prototype.getDefaultTerminalLinux = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                if (!this.DEFAULT_TERMINAL_LINUX_READY) {
                    this.DEFAULT_TERMINAL_LINUX_READY = new Promise(function (resolve) { return __awaiter(_this, void 0, void 0, function () {
                        var isDebian;
                        return __generator(this, function (_a) {
                            switch (_a.label) {
                                case 0:
                                    if (!(os_1.OS.type() === os_1.OS.Type.Linux)) return [3 /*break*/, 2];
                                    return [4 /*yield*/, fs.pathExists('/etc/debian_version')];
                                case 1:
                                    isDebian = _a.sent();
                                    if (isDebian) {
                                        resolve('x-terminal-emulator');
                                    }
                                    else if (process.env.DESKTOP_SESSION === 'gnome' || process.env.DESKTOP_SESSION === 'gnome-classic') {
                                        resolve('gnome-terminal');
                                    }
                                    else if (process.env.DESKTOP_SESSION === 'kde-plasma') {
                                        resolve('konsole');
                                    }
                                    else if (process.env.COLORTERM) {
                                        resolve(process.env.COLORTERM);
                                    }
                                    else if (process.env.TERM) {
                                        resolve(process.env.TERM);
                                    }
                                    else {
                                        resolve('xterm');
                                    }
                                    return [3 /*break*/, 3];
                                case 2:
                                    resolve('xterm');
                                    _a.label = 3;
                                case 3: return [2 /*return*/];
                            }
                        });
                    }); });
                }
                return [2 /*return*/, this.DEFAULT_TERMINAL_LINUX_READY];
            });
        });
    };
    LinuxExternalTerminalService = __decorate([
        inversify_1.injectable()
    ], LinuxExternalTerminalService);
    return LinuxExternalTerminalService;
}());
exports.LinuxExternalTerminalService = LinuxExternalTerminalService;
//# sourceMappingURL=linux-external-terminal-service.js.map