/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
/// <reference types="@theia/monaco-editor-core/monaco" />
import { ProblemManager } from '@theia/markers/lib/browser/problem/problem-manager';
import URI from '@theia/core/lib/common/uri';
import { Mutable } from '@theia/core/lib/common/types';
import { Disposable } from '@theia/core/lib/common/disposable';
import { MaybePromise } from '@theia/core/lib/common/types';
import { CancellationToken } from '@theia/core/lib/common/cancellation';
import { WorkspaceSymbolParams } from '@theia/core/shared/vscode-languageserver-protocol';
import { SymbolInformation } from '@theia/core/shared/vscode-languageserver-types';
import { Language, LanguageService } from '@theia/core/lib/browser/language-service';
import { MonacoDiagnosticCollection } from './monaco-diagnostic-collection';
import { ProtocolToMonacoConverter } from './protocol-to-monaco-converter';
export interface WorkspaceSymbolProvider {
    provideWorkspaceSymbols(params: WorkspaceSymbolParams, token: CancellationToken): MaybePromise<SymbolInformation[] | undefined>;
    resolveWorkspaceSymbol?(symbol: SymbolInformation, token: CancellationToken): Thenable<SymbolInformation | undefined>;
}
export declare class MonacoLanguages implements LanguageService {
    readonly workspaceSymbolProviders: WorkspaceSymbolProvider[];
    protected readonly makers: Map<string, MonacoDiagnosticCollection>;
    protected readonly problemManager: ProblemManager;
    protected readonly p2m: ProtocolToMonacoConverter;
    protected init(): void;
    protected updateMarkers(uri: URI): void;
    registerWorkspaceSymbolProvider(provider: WorkspaceSymbolProvider): Disposable;
    get languages(): Language[];
    getLanguage(languageId: string): Language | undefined;
    protected mergeLanguages(registered: monaco.languages.ILanguageExtensionPoint[]): Map<string, Mutable<Language>>;
}
//# sourceMappingURL=monaco-languages.d.ts.map