/********************************************************************************
 * Copyright (C) 2020 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { Emitter, Event } from '@theia/core/lib/common/event';
import { TabBarDecorator } from '@theia/core/lib/browser/shell/tab-bar-decorator';
import { ApplicationShell, FrontendApplication, FrontendApplicationContribution, Title, Widget } from '@theia/core/lib/browser';
import { WidgetDecoration } from '@theia/core/lib/browser/widget-decoration';
export declare class NavigatorTabBarDecorator implements TabBarDecorator, FrontendApplicationContribution {
    readonly id = "theia-navigator-tabbar-decorator";
    protected applicationShell: ApplicationShell;
    protected readonly emitter: Emitter<void>;
    private readonly toDispose;
    private readonly toDisposeOnDirtyChanged;
    onStart(app: FrontendApplication): void;
    decorate(title: Title<Widget>): WidgetDecoration.Data[];
    protected getDirtyEditorsCount(): number;
    get onDidChangeDecorations(): Event<void>;
    protected fireDidChangeDecorations(): void;
}
//# sourceMappingURL=navigator-tab-bar-decorator.d.ts.map