"use strict";
/********************************************************************************
 * Copyright (C) 2020 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.OutputUri = void 0;
var uri_1 = require("@theia/core/lib/common/uri");
var OutputUri;
(function (OutputUri) {
    OutputUri.SCHEME = 'output';
    function is(uri) {
        if (uri instanceof uri_1.default) {
            return uri.scheme === OutputUri.SCHEME;
        }
        return is(new uri_1.default(uri));
    }
    OutputUri.is = is;
    function create(name) {
        if (!name) {
            throw new Error("'name' must be defined.");
        }
        if (!name.trim().length) {
            throw new Error("'name' must contain at least one non-whitespace character.");
        }
        return new uri_1.default(encodeURIComponent(name)).withScheme(OutputUri.SCHEME);
    }
    OutputUri.create = create;
    function channelName(uri) {
        if (!is(uri)) {
            throw new Error("Expected '" + OutputUri.SCHEME + "' URI scheme. Got: " + uri + " instead.");
        }
        return (uri instanceof uri_1.default ? uri : new uri_1.default(uri)).toString(true).slice((OutputUri.SCHEME + ":/").length);
    }
    OutputUri.channelName = channelName;
})(OutputUri = exports.OutputUri || (exports.OutputUri = {}));
//# sourceMappingURL=output-uri.js.map