/********************************************************************************
 * Copyright (C) 2020 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { interfaces } from '@theia/core/shared/inversify';
import { AuthenticationExt, AuthenticationMain } from '../../common/plugin-api-rpc';
import { RPCProtocol } from '../../common/rpc-protocol';
import { MessageService } from '@theia/core/lib/common/message-service';
import { StorageService } from '@theia/core/lib/browser';
import { AuthenticationProvider } from '@theia/core/lib/browser/authentication-service';
import { AuthenticationSession, AuthenticationSessionsChangeEvent } from '../../common/plugin-api-rpc-model';
export declare class AuthenticationMainImpl implements AuthenticationMain {
    private readonly proxy;
    private readonly messageService;
    private readonly storageService;
    private readonly authenticationService;
    private readonly quickPickService;
    constructor(rpc: RPCProtocol, container: interfaces.Container);
    $getProviderIds(): Promise<string[]>;
    $registerAuthenticationProvider(id: string, label: string, supportsMultipleAccounts: boolean): Promise<void>;
    $unregisterAuthenticationProvider(id: string): Promise<void>;
    $updateSessions(id: string, event: AuthenticationSessionsChangeEvent): Promise<void>;
    $logout(providerId: string, sessionId: string): Promise<void>;
    protected requestNewSession(providerId: string, scopes: string[], extensionId: string, extensionName: string): Promise<void>;
    $getSession(providerId: string, scopes: string[], extensionId: string, extensionName: string, options: {
        createIfNone: boolean;
        clearSessionPreference: boolean;
    }): Promise<AuthenticationSession | undefined>;
    protected selectSession(providerId: string, providerName: string, extensionId: string, extensionName: string, potentialSessions: AuthenticationSession[], scopes: string[], clearSessionPreference: boolean): Promise<AuthenticationSession>;
    protected getSessionsPrompt(providerId: string, accountName: string, providerName: string, extensionId: string, extensionName: string): Promise<boolean>;
    protected loginPrompt(providerName: string, extensionName: string): Promise<boolean>;
    protected setTrustedExtensionAndAccountPreference(providerId: string, accountName: string, extensionId: string, extensionName: string, sessionId: string): Promise<void>;
}
export declare class AuthenticationProviderImpl implements AuthenticationProvider {
    private readonly proxy;
    readonly id: string;
    readonly label: string;
    readonly supportsMultipleAccounts: boolean;
    private readonly storageService;
    private readonly messageService;
    private accounts;
    private sessions;
    constructor(proxy: AuthenticationExt, id: string, label: string, supportsMultipleAccounts: boolean, storageService: StorageService, messageService: MessageService);
    hasSessions(): boolean;
    private registerSession;
    signOut(accountName: string): Promise<void>;
    getSessions(): Promise<ReadonlyArray<AuthenticationSession>>;
    updateSessionItems(event: AuthenticationSessionsChangeEvent): Promise<void>;
    login(scopes: string[]): Promise<AuthenticationSession>;
    logout(sessionId: string): Promise<void>;
}
//# sourceMappingURL=authentication-main.d.ts.map