/********************************************************************************
 * Copyright (C) 2020 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { interfaces } from '@theia/core/shared/inversify';
import { BinaryBuffer } from '@theia/core/lib/common/buffer';
import { Disposable } from '@theia/core/lib/common/disposable';
import { FileSystemMain, IFileChangeDto } from '../../common/plugin-api-rpc';
import { RPCProtocol } from '../../common/rpc-protocol';
import { UriComponents } from '../../common/uri-components';
import { FileSystemProviderCapabilities, Stat, FileType, FileOverwriteOptions, FileDeleteOptions } from '@theia/filesystem/lib/common/files';
export declare class FileSystemMainImpl implements FileSystemMain, Disposable {
    private readonly _proxy;
    private readonly _fileProvider;
    private readonly _fileService;
    constructor(rpc: RPCProtocol, container: interfaces.Container);
    dispose(): void;
    $registerFileSystemProvider(handle: number, scheme: string, capabilities: FileSystemProviderCapabilities): void;
    $unregisterProvider(handle: number): void;
    $onFileSystemChange(handle: number, changes: IFileChangeDto[]): void;
    $stat(uri: UriComponents): Promise<Stat>;
    $readdir(uri: UriComponents): Promise<[string, FileType][]>;
    $readFile(uri: UriComponents): Promise<BinaryBuffer>;
    $writeFile(uri: UriComponents, content: BinaryBuffer): Promise<void>;
    $rename(source: UriComponents, target: UriComponents, opts: FileOverwriteOptions): Promise<void>;
    $copy(source: UriComponents, target: UriComponents, opts: FileOverwriteOptions): Promise<void>;
    $mkdir(uri: UriComponents): Promise<void>;
    $delete(uri: UriComponents, opts: FileDeleteOptions): Promise<void>;
    private static _handleError;
}
//# sourceMappingURL=file-system-main-impl.d.ts.map