/********************************************************************************
 * Copyright (C) 2018 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { interfaces } from '@theia/core/shared/inversify';
import { TerminalOptions } from '@theia/plugin';
import { TerminalWidget } from '@theia/terminal/lib/browser/base/terminal-widget';
import { TerminalServiceMain } from '../../common/plugin-api-rpc';
import { RPCProtocol } from '../../common/rpc-protocol';
import { Disposable } from '@theia/core/lib/common/disposable';
import { SerializableEnvironmentVariableCollection } from '@theia/terminal/lib/common/base-terminal-protocol';
/**
 * Plugin api service allows working with terminal emulator.
 */
export declare class TerminalServiceMainImpl implements TerminalServiceMain, Disposable {
    private readonly terminals;
    private readonly shell;
    private readonly extProxy;
    private readonly shellTerminalServer;
    private readonly toDispose;
    constructor(rpc: RPCProtocol, container: interfaces.Container);
    $setEnvironmentVariableCollection(extensionIdentifier: string, persistent: boolean, collection: SerializableEnvironmentVariableCollection | undefined): void;
    dispose(): void;
    protected updateCurrentTerminal(): void;
    protected trackTerminal(terminal: TerminalWidget): Promise<void>;
    $write(id: string, data: string): void;
    $resize(id: string, cols: number, rows: number): void;
    $createTerminal(id: string, options: TerminalOptions, isPseudoTerminal?: boolean): Promise<string>;
    $sendText(id: string, text: string, addNewLine?: boolean): void;
    $show(id: string, preserveFocus?: boolean): void;
    $hide(id: string): void;
    $dispose(id: string): void;
    $sendTextByTerminalId(id: number, text: string, addNewLine?: boolean): void;
    $writeByTerminalId(id: number, data: string): void;
    $resizeByTerminalId(id: number, cols: number, rows: number): void;
    $showByTerminalId(id: number, preserveFocus?: boolean): void;
    $hideByTerminalId(id: number): void;
    $disposeByTerminalId(id: number, waitOnExit?: boolean | string): void;
}
//# sourceMappingURL=terminal-main.d.ts.map