/********************************************************************************
 * Copyright (C) 2018 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
/// <reference types="express" />
/// <reference types="node" />
import * as http from 'http';
import * as express from '@theia/core/shared/express';
import { BackendApplicationContribution } from '@theia/core/lib/node/backend-application';
import { WsRequestValidatorContribution } from '@theia/core/lib/node/ws-request-validators';
import { MaybePromise } from '@theia/core/lib/common';
export declare class PluginApiContribution implements BackendApplicationContribution, WsRequestValidatorContribution {
    protected webviewExternalEndpointRegExp: RegExp;
    protected serveSameOrigin: boolean;
    protected postConstruct(): void;
    configure(app: express.Application): void;
    allowWsUpgrade(request: http.IncomingMessage): MaybePromise<boolean>;
    protected webviewExternalEndpointPattern(): string;
    /**
     * Returns a RegExp pattern matching the expected WebView endpoint's host.
     */
    protected webviewExternalEndpoint(): string;
}
//# sourceMappingURL=plugin-service.d.ts.map