/********************************************************************************
 * Copyright (C) 2018 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { URI } from '@theia/core/shared/vscode-uri';
import * as theia from '@theia/plugin';
import * as model from '../../common/plugin-api-rpc-model';
import { DocumentsExtImpl } from '../documents';
import { WorkspaceEditDto } from '../../common/plugin-api-rpc';
import { Position } from '../../common/plugin-api-rpc';
export declare class RenameAdapter {
    private readonly provider;
    private readonly documents;
    static supportsResolving(provider: theia.RenameProvider): boolean;
    constructor(provider: theia.RenameProvider, documents: DocumentsExtImpl);
    provideRenameEdits(resource: URI, position: Position, newName: string, token: theia.CancellationToken): Promise<WorkspaceEditDto | undefined>;
    resolveRenameLocation(resource: URI, position: Position, token: theia.CancellationToken): Promise<model.RenameLocation & model.Rejection | undefined>;
    private static asMessage;
}
//# sourceMappingURL=rename.d.ts.map