/********************************************************************************
 * Copyright (C) 2020 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { BinaryBuffer } from '@theia/core/src/common/buffer';
import * as theia from '@theia/plugin';
import { URI } from '@theia/core/shared/vscode-uri';
import { DocumentsExtImpl } from '../documents';
import { Range } from '../../common/plugin-api-rpc-model';
export declare class DocumentSemanticTokensAdapter {
    private readonly _documents;
    private readonly _provider;
    private readonly _previousResults;
    private _nextResultId;
    constructor(_documents: DocumentsExtImpl, _provider: theia.DocumentSemanticTokensProvider);
    provideDocumentSemanticTokens(resource: URI, previousResultId: number, token: theia.CancellationToken): Promise<BinaryBuffer | null>;
    releaseDocumentSemanticColoring(semanticColoringResultId: number): Promise<void>;
    private static _fixProvidedSemanticTokens;
    private static _isSemanticTokens;
    private static _isCorrectSemanticTokens;
    private static _isSemanticTokensEdits;
    private static _isCorrectSemanticTokensEdits;
    private static _convertToEdits;
    private _send;
}
export declare class DocumentRangeSemanticTokensAdapter {
    private readonly _documents;
    private readonly _provider;
    constructor(_documents: DocumentsExtImpl, _provider: theia.DocumentRangeSemanticTokensProvider);
    provideDocumentRangeSemanticTokens(resource: URI, range: Range, token: theia.CancellationToken): Promise<BinaryBuffer | null>;
    private _send;
}
//# sourceMappingURL=semantic-highlighting.d.ts.map