"use strict";
/********************************************************************************
 * Copyright (C) 2018 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveDebugAdapterExecutable = void 0;
var path = require("path");
var os_1 = require("@theia/core/lib/common/os");
/**
 * Resolves [DebugAdapterExecutable](#DebugAdapterExecutable) based on contribution.
 */
function resolveDebugAdapterExecutable(pluginPath, debuggerContribution) {
    return __awaiter(this, void 0, void 0, function () {
        var info, program, programArgs, runtime, runtimeArgs, command, args;
        return __generator(this, function (_a) {
            info = toPlatformInfo(debuggerContribution);
            program = (info && info.program || debuggerContribution.program);
            if (!program) {
                return [2 /*return*/, undefined];
            }
            program = path.join(pluginPath, program);
            programArgs = info && info.args || debuggerContribution.args || [];
            runtime = info && info.runtime || debuggerContribution.runtime;
            if (runtime && runtime.indexOf('./') === 0) {
                runtime = path.join(pluginPath, runtime);
            }
            runtimeArgs = info && info.runtimeArgs || debuggerContribution.runtimeArgs || [];
            command = runtime ? runtime : program;
            args = runtime ? __spread(runtimeArgs, [program], programArgs) : programArgs;
            return [2 /*return*/, {
                    command: command,
                    args: args
                }];
        });
    });
}
exports.resolveDebugAdapterExecutable = resolveDebugAdapterExecutable;
function toPlatformInfo(executable) {
    if (os_1.isWindows && !process.env.hasOwnProperty('PROCESSOR_ARCHITEW6432')) {
        return executable.winx86 || executable.win || executable.windows;
    }
    if (os_1.isWindows) {
        return executable.win || executable.windows;
    }
    if (os_1.isOSX) {
        return executable.osx;
    }
    return executable.linux;
}
//# sourceMappingURL=plugin-debug-adapter-executable-resolver.js.map