/********************************************************************************
 * Copyright (C) 2019 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { Plugin, TimelineExt } from '../common';
import { RPCProtocol } from '../common/rpc-protocol';
import { Disposable } from './types-impl';
import { CommandRegistryImpl } from './command-registry';
import type { InternalTimelineOptions, Timeline } from '@theia/timeline/lib/common/timeline-model';
import * as theia from '@theia/plugin';
import { UriComponents } from '../common/uri-components';
export declare class TimelineExtImpl implements TimelineExt {
    readonly rpc: RPCProtocol;
    private readonly commands;
    readonly _serviceBrand: undefined;
    private readonly proxy;
    private providers;
    private itemsBySourceAndUriMap;
    constructor(rpc: RPCProtocol, commands: CommandRegistryImpl);
    $getTimeline(id: string, uri: UriComponents, options: theia.TimelineOptions, internalOptions?: InternalTimelineOptions): Promise<Timeline | undefined>;
    registerTimelineProvider(plugin: Plugin, scheme: string | string[], provider: theia.TimelineProvider): Disposable;
    private convertTimelineItem;
    private registerTimelineProviderCore;
}
//# sourceMappingURL=timeline.d.ts.map