/********************************************************************************
 * Copyright (C) 2018 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { InMemoryResources } from '@theia/core';
import { JsonSchemaRegisterContext, JsonSchemaContribution } from '@theia/core/lib/browser/json-schema-store';
import { PreferenceSchemaProvider } from '@theia/core/lib/browser/preferences/preference-contribution';
import { PreferenceConfigurations } from '@theia/core/lib/browser/preferences/preference-configurations';
import { WorkspaceService } from '@theia/workspace/lib/browser';
export declare class PreferencesJsonSchemaContribution implements JsonSchemaContribution {
    private serializeSchema;
    protected readonly schemaProvider: PreferenceSchemaProvider;
    protected readonly inmemoryResources: InMemoryResources;
    protected readonly preferenceConfigurations: PreferenceConfigurations;
    protected readonly workspaceService: WorkspaceService;
    registerSchemas(context: JsonSchemaRegisterContext): void;
    private registerSchema;
    private updateInMemoryResources;
    private getSchemaURIForScope;
    private getFileMatch;
}
//# sourceMappingURL=preferences-json-schema-contribution.d.ts.map