"use strict";
/********************************************************************************
 * Copyright (C) 2020 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
/* eslint-disable @typescript-eslint/no-explicit-any */
var jsdom_1 = require("@theia/core/lib/browser/test/jsdom");
var disableJSDOM = jsdom_1.enableJSDOM();
var frontend_application_config_provider_1 = require("@theia/core/lib/browser/frontend-application-config-provider");
var application_props_1 = require("@theia/application-package/lib/application-props");
frontend_application_config_provider_1.FrontendApplicationConfigProvider.set(__assign({}, application_props_1.ApplicationProps.DEFAULT.frontend.config));
var chai_1 = require("chai");
var inversify_1 = require("@theia/core/shared/inversify");
var preference_tree_generator_1 = require("./preference-tree-generator");
var browser_1 = require("@theia/core/lib/browser");
var preference_configurations_1 = require("@theia/core/lib/browser/preferences/preference-configurations");
disableJSDOM();
describe('preference-tree-generator', function () {
    var preferenceTreeGenerator;
    beforeEach(function () {
        var container = new inversify_1.Container();
        container.bind(browser_1.PreferenceSchemaProvider).toConstantValue({ onDidPreferenceSchemaChanged: function () { } });
        container.bind(preference_configurations_1.PreferenceConfigurations).toConstantValue(undefined);
        preferenceTreeGenerator = container.resolve(preference_tree_generator_1.PreferenceTreeGenerator);
    });
    it('PreferenceTreeGenerator.split', function () {
        // We want to ensure that our `split` function emulates the following regex properly:
        var splitter = /[\W_]|(?<=[^A-Z])(?=[A-Z])/;
        var testString = 'aaaBbb.Ccc d E fff GGGgg_iiiJ0a';
        chai_1.expect(preferenceTreeGenerator['split'](testString)).deep.eq(testString.split(splitter));
    });
    it('PreferenceTreeGenerator.format', function () {
        var testString = 'aaaBbbCcc Dddd eee';
        chai_1.expect(preferenceTreeGenerator['formatString'](testString)).eq('Aaa Bbb Ccc Dddd eee');
    });
    it('PreferenceTreeGenerator.format.chinese', function () {
        var testString = '某個設定/某个设定';
        chai_1.expect(preferenceTreeGenerator['formatString'](testString)).eq('某個設定/某个设定');
    });
    it('PreferenceTreeGenerator.format.Danish', function () {
        var testString = 'indstillingPåEnØ';
        chai_1.expect(preferenceTreeGenerator['formatString'](testString)).eq('Indstilling På En Ø');
    });
    it('PreferenceTreeGenerator.format.Greek', function () {
        var testString = 'κάποιαΡύθμιση';
        chai_1.expect(preferenceTreeGenerator['formatString'](testString)).eq('Κάποια Ρύθμιση');
    });
    it('PreferenceTreeGenerator.format.Russian', function () {
        var testString = 'некоторыеНастройки';
        chai_1.expect(preferenceTreeGenerator['formatString'](testString)).eq('Некоторые Настройки');
    });
    it('PreferenceTreeGenerator.format.Armenian', function () {
        var testString = 'ինչ-որՊարամետր';
        chai_1.expect(preferenceTreeGenerator['formatString'](testString)).eq('Ինչ-որ Պարամետր');
    });
    it('PreferenceTreeGenerator.format.specialCharacters', function () {
        var testString = 'hyphenated-wordC++Setting';
        chai_1.expect(preferenceTreeGenerator['formatString'](testString)).eq('Hyphenated-word C++ Setting');
    });
    describe('PreferenceTreeGenerator.createLeafNode', function () {
        it('when property constructs of three parts the third part is the leaf', function () {
            var property = 'category-name.subcategory.leaf';
            var expectedName = 'Leaf';
            testLeafName(property, expectedName);
        });
        it('when property constructs of two parts the second part is the leaf', function () {
            var property = 'category-name.leaf';
            var expectedName = 'Leaf';
            testLeafName(property, expectedName);
        });
        function testLeafName(property, expectedName) {
            var preferencesGroups = [];
            var root = preferenceTreeGenerator['createRootNode'](preferencesGroups);
            var preferencesGroup = preferenceTreeGenerator['createPreferencesGroup']('group', root);
            var expectedSelectableTreeNode = {
                id: property,
                name: expectedName,
                parent: preferencesGroup,
                visible: true,
                selected: false,
            };
            chai_1.expect(preferenceTreeGenerator['createLeafNode'](property, preferencesGroup)).deep.eq(expectedSelectableTreeNode);
        }
    });
});
//# sourceMappingURL=preference-tree-generator.spec.js.map