/********************************************************************************
 * Copyright (C) 2020 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { PreferenceDataProperty, PreferenceItem, Title, TreeNode } from '@theia/core/lib/browser';
import { Command, MenuPath } from '@theia/core';
export declare namespace Preference {
    interface ValueInSingleScope {
        value?: PreferenceItem;
        data: PreferenceDataProperty;
    }
    interface NodeWithValueInSingleScope extends TreeNode {
        preference: ValueInSingleScope;
    }
    interface ValuesInAllScopes {
        preferenceName: string;
        defaultValue: PreferenceItem | undefined;
        globalValue: PreferenceItem | undefined;
        workspaceValue: PreferenceItem | undefined;
        workspaceFolderValue: PreferenceItem | undefined;
    }
    interface PreferenceWithValueInAllScopes {
        values?: ValuesInAllScopes;
        data: PreferenceDataProperty;
    }
    interface EditorCommandArgs {
        id: string;
        value: string | undefined;
    }
    namespace EditorCommandArgs {
        function is(prefObject: EditorCommandArgs): prefObject is EditorCommandArgs;
    }
    interface NodeWithValueInAllScopes extends TreeNode {
        preference: PreferenceWithValueInAllScopes;
    }
    const getValueInScope: (preferenceInfo: ValuesInAllScopes | undefined, scope: number) => PreferenceItem | undefined;
    interface SelectedScopeDetails extends Title.Dataset {
        scope: string;
        uri: string;
        activeScopeIsFolder: string;
    }
    const DEFAULT_SCOPE: SelectedScopeDetails;
    interface ContextMenuCallbacks {
        resetCallback(): void;
        copyIDCallback(): void;
        copyJSONCallback(): void;
    }
}
export declare namespace PreferencesCommands {
    const OPEN_PREFERENCES_JSON_TOOLBAR: Command;
    const COPY_JSON_NAME: Command;
    const RESET_PREFERENCE: Command;
    const COPY_JSON_VALUE: Command;
}
export declare namespace PreferenceMenus {
    const PREFERENCE_EDITOR_CONTEXT_MENU: MenuPath;
    const PREFERENCE_EDITOR_COPY_ACTIONS: MenuPath;
}
//# sourceMappingURL=preference-types.d.ts.map