/********************************************************************************
 * Copyright (C) 2020 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
/// <reference types="react" />
/// <reference types="lodash" />
import * as React from '@theia/core/shared/react';
import { ReactWidget, PreferenceService, SelectableTreeNode, TreeNode, StatefulWidget } from '@theia/core/lib/browser';
import { Message } from '@theia/core/lib/browser/widgets/widget';
import { SinglePreferenceDisplayFactory } from './components/single-preference-display-factory';
import { PreferenceTreeModel, PreferenceTreeNodeRow } from '../preference-tree-model';
import { Emitter } from '@theia/core';
export interface PreferencesEditorState {
    firstVisibleChildID: string;
}
export declare class PreferencesEditorWidget extends ReactWidget implements StatefulWidget {
    static readonly ID = "settings.editor";
    static readonly LABEL = "Settings Editor";
    protected readonly onEditorScrollEmitter: Emitter<boolean>;
    /**
     * true = at top; false = not at top
     */
    readonly onEditorDidScroll: import("@theia/core/src/common").Event<boolean>;
    protected scrollContainerRef: React.RefObject<HTMLDivElement>;
    protected hasRendered: boolean;
    protected shouldScroll: boolean;
    protected lastUserSelection: string;
    protected isAtScrollTop: boolean;
    protected firstVisibleChildID: string;
    protected readonly preferenceValueRetrievalService: PreferenceService;
    protected readonly model: PreferenceTreeModel;
    protected readonly singlePreferenceFactory: SinglePreferenceDisplayFactory;
    protected init(): void;
    protected callAfterFirstRender(callback: Function): void;
    protected onAfterAttach(msg: Message): void;
    protected render(): React.ReactNode;
    protected handleDisplayChange: (filterWasCleared?: boolean) => void;
    protected doOnScroll: () => void;
    onScroll: import("lodash").DebouncedFunc<() => void>;
    protected findFirstVisibleChildID(container: Element): {
        selectionAncestorID: string;
        expansionAncestorID: string;
    } | undefined;
    protected isInView(e: HTMLElement, parent: HTMLElement): boolean;
    protected compare: (value: number) => {
        isBetween: (a: number, b: number) => boolean;
    };
    protected renderSingleEntry(node: TreeNode): React.ReactNode;
    protected renderCategoryHeader({ node, visibleChildren }: PreferenceTreeNodeRow): React.ReactNode;
    protected renderNoResultMessage(): React.ReactNode;
    protected handleSelectionChange(selectionEvent: readonly Readonly<SelectableTreeNode>[]): void;
    storeState(): PreferencesEditorState;
    restoreState(oldState: PreferencesEditorState): void;
}
//# sourceMappingURL=preference-editor-widget.d.ts.map