"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProcessManager = void 0;
/********************************************************************************
 * Copyright (C) 2017 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var inversify_1 = require("@theia/core/shared/inversify");
var common_1 = require("@theia/core/lib/common");
var logger_1 = require("@theia/core/lib/common/logger");
var ProcessManager = /** @class */ (function () {
    function ProcessManager(logger) {
        this.logger = logger;
        this.id = 0;
        this.processes = new Map();
        this.deleteEmitter = new common_1.Emitter();
    }
    /**
     * Registers the given process into this manager. Both on process termination and on error,
     * the process will be automatically removed from the manager.
     *
     * @param process the process to register.
     */
    ProcessManager.prototype.register = function (process) {
        var _this = this;
        var id = this.id;
        this.processes.set(id, process);
        process.onExit(function () { return _this.unregister(process); });
        process.onError(function () { return _this.unregister(process); });
        this.id++;
        return id;
    };
    /**
     * Removes the process from this process manager. Invoking this method, will make
     * sure that the process is terminated before eliminating it from the manager's cache.
     *
     * @param process the process to unregister from this process manager.
     */
    ProcessManager.prototype.unregister = function (process) {
        var processLabel = this.getProcessLabel(process);
        this.logger.debug("Unregistering process. " + processLabel);
        if (!process.killed) {
            this.logger.debug("Ensuring process termination. " + processLabel);
            process.kill();
        }
        if (this.processes.delete(process.id)) {
            this.deleteEmitter.fire(process.id);
            this.logger.debug("The process was successfully unregistered. " + processLabel);
        }
        else {
            this.logger.warn("This process was not registered or was already unregistered. " + processLabel);
        }
    };
    ProcessManager.prototype.get = function (id) {
        return this.processes.get(id);
    };
    Object.defineProperty(ProcessManager.prototype, "onDelete", {
        get: function () {
            return this.deleteEmitter.event;
        },
        enumerable: false,
        configurable: true
    });
    ProcessManager.prototype.onStop = function () {
        var e_1, _a;
        try {
            for (var _b = __values(this.processes.values()), _c = _b.next(); !_c.done; _c = _b.next()) {
                var process_1 = _c.value;
                try {
                    this.unregister(process_1);
                }
                catch (error) {
                    this.logger.error("Error occurred when unregistering process. " + this.getProcessLabel(process_1), error);
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
    };
    ProcessManager.prototype.getProcessLabel = function (process) {
        return "[ID: " + process.id + "]";
    };
    ProcessManager = __decorate([
        inversify_1.injectable(),
        __param(0, inversify_1.inject(logger_1.ILogger)), __param(0, inversify_1.named('process')),
        __metadata("design:paramtypes", [Object])
    ], ProcessManager);
    return ProcessManager;
}());
exports.ProcessManager = ProcessManager;
//# sourceMappingURL=process-manager.js.map