"use strict";
/********************************************************************************
 * Copyright (C) 2020 EclipseSource and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmptyPropertyViewWidgetProvider = void 0;
var browser_1 = require("@theia/core/lib/browser");
var inversify_1 = require("@theia/core/shared/inversify");
var React = require("@theia/core/shared/react");
var property_view_widget_provider_1 = require("./property-view-widget-provider");
var EmptyPropertyViewWidget = /** @class */ (function (_super) {
    __extends(EmptyPropertyViewWidget, _super);
    function EmptyPropertyViewWidget() {
        var _this = _super.call(this) || this;
        _this.emptyComponent = React.createElement("div", { className: 'theia-widget-noInfo' }, "No properties available.");
        _this.id = EmptyPropertyViewWidget.ID;
        _this.title.label = EmptyPropertyViewWidget.LABEL;
        _this.title.caption = EmptyPropertyViewWidget.LABEL;
        _this.title.closable = false;
        _this.node.tabIndex = 0;
        return _this;
    }
    EmptyPropertyViewWidget.prototype.updatePropertyViewContent = function () {
        this.update();
    };
    EmptyPropertyViewWidget.prototype.render = function () {
        return this.emptyComponent;
    };
    EmptyPropertyViewWidget.ID = 'theia-empty-property-view';
    EmptyPropertyViewWidget.LABEL = 'No Properties';
    return EmptyPropertyViewWidget;
}(browser_1.ReactWidget));
/**
 * `DefaultPropertyViewWidgetProvider` is implemented to provide the PropertyViewEmptyWidget
 *  if the given selection is undefined or no other provider can handle the given selection.
 */
var EmptyPropertyViewWidgetProvider = /** @class */ (function (_super) {
    __extends(EmptyPropertyViewWidgetProvider, _super);
    function EmptyPropertyViewWidgetProvider() {
        var _this = _super.call(this) || this;
        _this.id = EmptyPropertyViewWidgetProvider_1.ID;
        _this.label = 'DefaultPropertyViewWidgetProvider';
        _this.emptyWidget = new EmptyPropertyViewWidget();
        return _this;
    }
    EmptyPropertyViewWidgetProvider_1 = EmptyPropertyViewWidgetProvider;
    EmptyPropertyViewWidgetProvider.prototype.canHandle = function (selection) {
        return selection === undefined ? 1 : 0;
    };
    EmptyPropertyViewWidgetProvider.prototype.provideWidget = function (selection) {
        return Promise.resolve(this.emptyWidget);
    };
    EmptyPropertyViewWidgetProvider.prototype.updateContentWidget = function (selection) {
        this.emptyWidget.updatePropertyViewContent();
    };
    var EmptyPropertyViewWidgetProvider_1;
    EmptyPropertyViewWidgetProvider.ID = 'no-properties';
    EmptyPropertyViewWidgetProvider = EmptyPropertyViewWidgetProvider_1 = __decorate([
        inversify_1.injectable(),
        __metadata("design:paramtypes", [])
    ], EmptyPropertyViewWidgetProvider);
    return EmptyPropertyViewWidgetProvider;
}(property_view_widget_provider_1.DefaultPropertyViewWidgetProvider));
exports.EmptyPropertyViewWidgetProvider = EmptyPropertyViewWidgetProvider;
//# sourceMappingURL=empty-property-view-widget-provider.js.map