"use strict";
/********************************************************************************
 * Copyright (C) 2020 EclipseSource and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PropertyViewService = void 0;
var core_1 = require("@theia/core");
var inversify_1 = require("@theia/core/shared/inversify");
var empty_property_view_widget_provider_1 = require("./empty-property-view-widget-provider");
var property_view_widget_provider_1 = require("./property-view-widget-provider");
/**
 * `PropertyViewService` provides an access to existing property view widget providers.
 */
var PropertyViewService = /** @class */ (function () {
    function PropertyViewService() {
        this.providers = [];
    }
    PropertyViewService.prototype.init = function () {
        this.providers = this.providers.concat(this.contributions.getContributions());
    };
    /**
     * Return a property view widget provider with the highest priority for the given selection.
     * Never reject, return DefaultProvider ('No properties available') if no other matches.
     */
    PropertyViewService.prototype.getProvider = function (selection) {
        return __awaiter(this, void 0, void 0, function () {
            var provider;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.prioritize(selection)];
                    case 1:
                        provider = _a.sent();
                        return [2 /*return*/, provider !== null && provider !== void 0 ? provider : this.emptyWidgetProvider];
                }
            });
        });
    };
    PropertyViewService.prototype.prioritize = function (selection) {
        return __awaiter(this, void 0, void 0, function () {
            var prioritized;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, core_1.Prioritizeable.prioritizeAll(this.providers, function (provider) { return __awaiter(_this, void 0, void 0, function () {
                            var _a;
                            return __generator(this, function (_b) {
                                switch (_b.label) {
                                    case 0:
                                        _b.trys.push([0, 2, , 3]);
                                        return [4 /*yield*/, provider.canHandle(selection)];
                                    case 1: return [2 /*return*/, _b.sent()];
                                    case 2:
                                        _a = _b.sent();
                                        return [2 /*return*/, 0];
                                    case 3: return [2 /*return*/];
                                }
                            });
                        }); })];
                    case 1:
                        prioritized = _a.sent();
                        return [2 /*return*/, prioritized.length !== 0 ? prioritized[0].value : undefined];
                }
            });
        });
    };
    __decorate([
        inversify_1.inject(core_1.ContributionProvider),
        inversify_1.named(property_view_widget_provider_1.PropertyViewWidgetProvider),
        __metadata("design:type", Object)
    ], PropertyViewService.prototype, "contributions", void 0);
    __decorate([
        inversify_1.inject(empty_property_view_widget_provider_1.EmptyPropertyViewWidgetProvider),
        __metadata("design:type", empty_property_view_widget_provider_1.EmptyPropertyViewWidgetProvider)
    ], PropertyViewService.prototype, "emptyWidgetProvider", void 0);
    __decorate([
        inversify_1.postConstruct(),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", void 0)
    ], PropertyViewService.prototype, "init", null);
    PropertyViewService = __decorate([
        inversify_1.injectable()
    ], PropertyViewService);
    return PropertyViewService;
}());
exports.PropertyViewService = PropertyViewService;
//# sourceMappingURL=property-view-service.js.map