/********************************************************************************
 * Copyright (C) 2020 EclipseSource and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { Message } from '@theia/core/shared/@phosphor/messaging';
import { SelectionService } from '@theia/core';
import { BaseWidget, Widget } from '@theia/core/lib/browser/widgets/widget';
import { DisposableCollection } from '@theia/core/lib/common/disposable';
import { PropertyViewContentWidget } from './property-view-content-widget';
import { PropertyViewService } from './property-view-service';
export declare class PropertyViewWidget extends BaseWidget {
    static readonly ID = "property-view";
    static readonly LABEL = "Properties";
    protected contentWidget: PropertyViewContentWidget;
    protected toDisposeOnDetach: DisposableCollection;
    protected readonly propertyViewService: PropertyViewService;
    protected readonly selectionService: SelectionService;
    init(): void;
    protected initializeContentWidget(selection: Object | undefined): void;
    protected replaceContentWidget(newContentWidget: PropertyViewContentWidget): void;
    protected attachContentWidget(newContentWidget: PropertyViewContentWidget): void;
    protected onAfterAttach(msg: Message): void;
    protected onActivateRequest(msg: Message): void;
    protected onResize(msg: Widget.ResizeMessage): void;
}
//# sourceMappingURL=property-view-widget.d.ts.map