"use strict";
/********************************************************************************
 * Copyright (C) 2020 EclipseSource and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PropertyViewWidget = void 0;
var core_1 = require("@theia/core");
var widget_1 = require("@theia/core/lib/browser/widgets/widget");
var disposable_1 = require("@theia/core/lib/common/disposable");
var inversify_1 = require("@theia/core/shared/inversify");
var property_view_service_1 = require("./property-view-service");
var PropertyViewWidget = /** @class */ (function (_super) {
    __extends(PropertyViewWidget, _super);
    function PropertyViewWidget() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.toDisposeOnDetach = new disposable_1.DisposableCollection();
        return _this;
    }
    PropertyViewWidget_1 = PropertyViewWidget;
    PropertyViewWidget.prototype.init = function () {
        var _this = this;
        this.id = PropertyViewWidget_1.ID;
        this.title.label = PropertyViewWidget_1.LABEL;
        this.title.caption = PropertyViewWidget_1.LABEL;
        this.title.iconClass = 'fa fa-table';
        this.title.closable = true;
        this.addClass('theia-property-view-widget');
        this.node.tabIndex = 0;
        var disposed = false;
        this.toDispose.push(core_1.Disposable.create(function () { return disposed = true; }));
        this.toDispose.push(this.selectionService.onSelectionChanged(function (selection) {
            _this.propertyViewService.getProvider(selection).then(function (provider) {
                provider.provideWidget(selection).then(function (contentWidget) {
                    if (!disposed) {
                        _this.replaceContentWidget(contentWidget);
                        provider.updateContentWidget(selection);
                    }
                });
            });
        }));
    };
    PropertyViewWidget.prototype.initializeContentWidget = function (selection) {
        var _this = this;
        this.propertyViewService.getProvider(selection).then(function (provider) {
            provider.provideWidget(selection).then(function (contentWidget) {
                _this.attachContentWidget(contentWidget);
                provider.updateContentWidget(selection);
            });
        });
    };
    PropertyViewWidget.prototype.replaceContentWidget = function (newContentWidget) {
        if (this.contentWidget.id !== newContentWidget.id) {
            if (this.contentWidget) {
                widget_1.Widget.detach(this.contentWidget);
            }
            this.attachContentWidget(newContentWidget);
        }
    };
    PropertyViewWidget.prototype.attachContentWidget = function (newContentWidget) {
        var _this = this;
        this.contentWidget = newContentWidget;
        widget_1.Widget.attach(this.contentWidget, this.node);
        this.toDisposeOnDetach = new disposable_1.DisposableCollection();
        this.toDisposeOnDetach.push(core_1.Disposable.create(function () {
            if (_this.contentWidget) {
                widget_1.Widget.detach(_this.contentWidget);
            }
        }));
        this.update();
    };
    PropertyViewWidget.prototype.onAfterAttach = function (msg) {
        _super.prototype.onAfterAttach.call(this, msg);
        this.initializeContentWidget(this.selectionService.selection);
    };
    PropertyViewWidget.prototype.onActivateRequest = function (msg) {
        _super.prototype.onActivateRequest.call(this, msg);
        this.node.focus();
        if (this.contentWidget) {
            this.contentWidget.activate();
        }
    };
    PropertyViewWidget.prototype.onResize = function (msg) {
        _super.prototype.onResize.call(this, msg);
        if (this.contentWidget) {
            widget_1.MessageLoop.sendMessage(this.contentWidget, msg);
        }
    };
    var PropertyViewWidget_1;
    PropertyViewWidget.ID = 'property-view';
    PropertyViewWidget.LABEL = 'Properties';
    __decorate([
        inversify_1.inject(property_view_service_1.PropertyViewService),
        __metadata("design:type", property_view_service_1.PropertyViewService)
    ], PropertyViewWidget.prototype, "propertyViewService", void 0);
    __decorate([
        inversify_1.inject(core_1.SelectionService),
        __metadata("design:type", core_1.SelectionService)
    ], PropertyViewWidget.prototype, "selectionService", void 0);
    __decorate([
        inversify_1.postConstruct(),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", void 0)
    ], PropertyViewWidget.prototype, "init", null);
    PropertyViewWidget = PropertyViewWidget_1 = __decorate([
        inversify_1.injectable()
    ], PropertyViewWidget);
    return PropertyViewWidget;
}(widget_1.BaseWidget));
exports.PropertyViewWidget = PropertyViewWidget;
//# sourceMappingURL=property-view-widget.js.map