/********************************************************************************
 * Copyright (C) 2020 EclipseSource and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import URI from '@theia/core/lib/common/uri';
import { FileService } from '@theia/filesystem/lib/browser/file-service';
import { FileStat } from '@theia/filesystem/lib/common/files';
import { PropertyDataService } from '../property-data-service';
export declare class ResourcePropertyDataService implements PropertyDataService {
    readonly id = "resources";
    readonly label = "ResourcePropertyDataService";
    protected readonly fileService: FileService;
    canHandleSelection(selection: Object | undefined): number;
    protected isFileSelection(selection: Object | undefined): boolean;
    protected isNavigatableSelection(selection: Object | undefined): boolean;
    protected getFileStat(uri: URI): Promise<FileStat>;
    providePropertyData(selection: Object | undefined): Promise<FileStat | undefined>;
}
//# sourceMappingURL=resource-property-data-service.d.ts.map