"use strict";
/********************************************************************************
 * Copyright (C) 2020 EclipseSource and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResourcePropertyViewTreeWidget = void 0;
var browser_1 = require("@theia/core/lib/browser");
var inversify_1 = require("@theia/core/shared/inversify");
var React = require("@theia/core/shared/react");
var resource_property_view_tree_items_1 = require("./resource-property-view-tree-items");
var ResourcePropertyViewTreeWidget = /** @class */ (function (_super) {
    __extends(ResourcePropertyViewTreeWidget, _super);
    function ResourcePropertyViewTreeWidget(props, model, contextMenuRenderer) {
        var _this = _super.call(this, props, model, contextMenuRenderer) || this;
        _this.props = props;
        _this.contextMenuRenderer = contextMenuRenderer;
        model.root = {
            id: resource_property_view_tree_items_1.ROOT_ID,
            name: ResourcePropertyViewTreeWidget_1.LABEL,
            parent: undefined,
            visible: false,
            children: []
        };
        _this.propertiesTree = new Map();
        return _this;
    }
    ResourcePropertyViewTreeWidget_1 = ResourcePropertyViewTreeWidget;
    ResourcePropertyViewTreeWidget.prototype.init = function () {
        _super.prototype.init.call(this);
        this.id = ResourcePropertyViewTreeWidget_1.ID + '-treeContainer';
        this.addClass('treeContainer');
        this.fillPropertiesTree();
    };
    ResourcePropertyViewTreeWidget.prototype.updateNeeded = function (selection) {
        return this.currentSelection !== selection;
    };
    ResourcePropertyViewTreeWidget.prototype.updatePropertyViewContent = function (propertyDataService, selection) {
        var _this = this;
        if (this.updateNeeded(selection)) {
            this.currentSelection = selection;
            if (propertyDataService) {
                propertyDataService.providePropertyData(selection).then(function (fileStatObject) {
                    _this.fillPropertiesTree(fileStatObject);
                });
            }
        }
    };
    ResourcePropertyViewTreeWidget.prototype.fillPropertiesTree = function (fileStatObject) {
        if (fileStatObject) {
            this.propertiesTree.clear();
            var infoNode = this.createCategoryNode('info', 'Info');
            this.propertiesTree.set('info', infoNode);
            infoNode.children.push(this.createResultLineNode('isDirectory', 'Directory', fileStatObject.isDirectory, infoNode));
            infoNode.children.push(this.createResultLineNode('isFile', 'File', fileStatObject.isFile, infoNode));
            infoNode.children.push(this.createResultLineNode('isSymbolicLink', 'Symbolic link', fileStatObject.isSymbolicLink, infoNode));
            infoNode.children.push(this.createResultLineNode('location', 'Location', this.getLocationString(fileStatObject), infoNode));
            infoNode.children.push(this.createResultLineNode('name', 'Name', this.getFileName(fileStatObject), infoNode));
            infoNode.children.push(this.createResultLineNode('path', 'Path', this.getFilePath(fileStatObject), infoNode));
            infoNode.children.push(this.createResultLineNode('lastModification', 'Last modified', this.getLastModificationString(fileStatObject), infoNode));
            infoNode.children.push(this.createResultLineNode('created', 'Created', this.getCreationTimeString(fileStatObject), infoNode));
            infoNode.children.push(this.createResultLineNode('size', 'Size', this.getSizeString(fileStatObject), infoNode));
            this.refreshModelChildren();
        }
    };
    ResourcePropertyViewTreeWidget.prototype.getLocationString = function (fileStat) {
        return fileStat.resource.path.toString();
    };
    ResourcePropertyViewTreeWidget.prototype.getFileName = function (fileStat) {
        return this.labelProvider.getName(fileStat.resource);
    };
    ResourcePropertyViewTreeWidget.prototype.getFilePath = function (fileStat) {
        return this.labelProvider.getLongName(fileStat.resource);
    };
    ResourcePropertyViewTreeWidget.prototype.getLastModificationString = function (fileStat) {
        return fileStat.mtime ? new Date(fileStat.mtime).toLocaleString() : '';
    };
    ResourcePropertyViewTreeWidget.prototype.getCreationTimeString = function (fileStat) {
        return fileStat.ctime ? new Date(fileStat.ctime).toLocaleString() : '';
    };
    ResourcePropertyViewTreeWidget.prototype.getSizeString = function (fileStat) {
        return fileStat.size ? fileStat.size + ' bytes' : '';
    };
    /*
    * Creating TreeNodes
    */
    ResourcePropertyViewTreeWidget.prototype.createCategoryNode = function (categoryId, name) {
        return {
            id: categoryId,
            parent: this.model.root,
            name: name,
            children: [],
            categoryId: categoryId,
            selected: false,
            expanded: true
        };
    };
    ResourcePropertyViewTreeWidget.prototype.createResultLineNode = function (id, name, property, parent) {
        return {
            id: parent.id + "::" + id,
            parent: parent,
            name: name,
            property: property !== undefined ? String(property) : '',
            selected: false
        };
    };
    /**
     * Rendering
     */
    ResourcePropertyViewTreeWidget.prototype.refreshModelChildren = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                if (resource_property_view_tree_items_1.ResourcePropertiesRoot.is(this.model.root)) {
                    this.model.root.children = Array.from(this.propertiesTree.values());
                    this.model.refresh();
                }
                return [2 /*return*/];
            });
        });
    };
    ResourcePropertyViewTreeWidget.prototype.renderCaption = function (node, props) {
        if (resource_property_view_tree_items_1.ResourcePropertiesCategoryNode.is(node)) {
            return this.renderExpandableNode(node);
        }
        else if (resource_property_view_tree_items_1.ResourcePropertiesItemNode.is(node)) {
            return this.renderItemNode(node);
        }
        return undefined;
    };
    ResourcePropertyViewTreeWidget.prototype.renderExpandableNode = function (node) {
        return React.createElement(React.Fragment, null,
            React.createElement("div", { className: "theia-resource-tree-node-icon " + this.toNodeIcon(node) }),
            React.createElement("div", { className: 'theia-resource-tree-node-name theia-TreeNodeSegment theia-TreeNodeSegmentGrow' }, this.toNodeName(node)));
    };
    ResourcePropertyViewTreeWidget.prototype.renderItemNode = function (node) {
        return React.createElement(React.Fragment, null,
            React.createElement("div", { className: "theia-resource-tree-node-icon " + this.toNodeIcon(node) }),
            React.createElement("div", { className: 'theia-resource-tree-node-name theia-TreeNodeSegment theia-TreeNodeSegmentGrow' }, this.toNodeName(node)),
            React.createElement("div", { className: 'theia-resource-tree-node-property theia-TreeNodeSegment theia-TreeNodeSegmentGrow' }, this.toNodeDescription(node)));
    };
    ResourcePropertyViewTreeWidget.prototype.createNodeAttributes = function (node, props) {
        return __assign(__assign({}, _super.prototype.createNodeAttributes.call(this, node, props)), { title: this.getNodeTooltip(node) });
    };
    ResourcePropertyViewTreeWidget.prototype.getNodeTooltip = function (node) {
        if (resource_property_view_tree_items_1.ResourcePropertiesCategoryNode.is(node)) {
            return this.labelProvider.getName(node);
        }
        else if (resource_property_view_tree_items_1.ResourcePropertiesItemNode.is(node)) {
            return this.labelProvider.getName(node) + ": " + this.labelProvider.getLongName(node);
        }
        return undefined;
    };
    var ResourcePropertyViewTreeWidget_1;
    ResourcePropertyViewTreeWidget.ID = 'resource-properties-tree-widget';
    ResourcePropertyViewTreeWidget.LABEL = 'Resource Properties Tree';
    __decorate([
        inversify_1.inject(browser_1.LabelProvider),
        __metadata("design:type", browser_1.LabelProvider)
    ], ResourcePropertyViewTreeWidget.prototype, "labelProvider", void 0);
    __decorate([
        inversify_1.postConstruct(),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", void 0)
    ], ResourcePropertyViewTreeWidget.prototype, "init", null);
    ResourcePropertyViewTreeWidget = ResourcePropertyViewTreeWidget_1 = __decorate([
        inversify_1.injectable(),
        __param(0, inversify_1.inject(browser_1.TreeProps)),
        __param(1, inversify_1.inject(browser_1.TreeModel)),
        __param(2, inversify_1.inject(browser_1.ContextMenuRenderer)),
        __metadata("design:paramtypes", [Object, Object, browser_1.ContextMenuRenderer])
    ], ResourcePropertyViewTreeWidget);
    return ResourcePropertyViewTreeWidget;
}(browser_1.TreeWidget));
exports.ResourcePropertyViewTreeWidget = ResourcePropertyViewTreeWidget;
//# sourceMappingURL=resource-property-view-tree-widget.js.map