"use strict";
/********************************************************************************
 * Copyright (C) 2020 EclipseSource and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResourcePropertyViewWidgetProvider = void 0;
var browser_1 = require("@theia/core/lib/browser");
var file_selection_1 = require("@theia/filesystem/lib/browser/file-selection");
var inversify_1 = require("@theia/core/shared/inversify");
var property_view_widget_provider_1 = require("../property-view-widget-provider");
var resource_property_view_tree_widget_1 = require("./resource-property-view-tree-widget");
var ResourcePropertyViewWidgetProvider = /** @class */ (function (_super) {
    __extends(ResourcePropertyViewWidgetProvider, _super);
    function ResourcePropertyViewWidgetProvider() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.id = 'resources';
        _this.label = 'ResourcePropertyViewWidgetProvider';
        return _this;
    }
    ResourcePropertyViewWidgetProvider.prototype.canHandle = function (selection) {
        return (this.isFileSelection(selection) || this.isNavigatableSelection(selection)) ? 1 : 0;
    };
    ResourcePropertyViewWidgetProvider.prototype.isFileSelection = function (selection) {
        return !!selection && Array.isArray(selection) && file_selection_1.FileSelection.is(selection[0]);
    };
    ResourcePropertyViewWidgetProvider.prototype.isNavigatableSelection = function (selection) {
        return !!selection && browser_1.Navigatable.is(selection);
    };
    ResourcePropertyViewWidgetProvider.prototype.provideWidget = function (selection) {
        return Promise.resolve(this.treeWidget);
    };
    ResourcePropertyViewWidgetProvider.prototype.updateContentWidget = function (selection) {
        var _this = this;
        this.getPropertyDataService(selection).then(function (service) { return _this.treeWidget.updatePropertyViewContent(service, selection); });
    };
    __decorate([
        inversify_1.inject(resource_property_view_tree_widget_1.ResourcePropertyViewTreeWidget),
        __metadata("design:type", resource_property_view_tree_widget_1.ResourcePropertyViewTreeWidget)
    ], ResourcePropertyViewWidgetProvider.prototype, "treeWidget", void 0);
    ResourcePropertyViewWidgetProvider = __decorate([
        inversify_1.injectable()
    ], ResourcePropertyViewWidgetProvider);
    return ResourcePropertyViewWidgetProvider;
}(property_view_widget_provider_1.DefaultPropertyViewWidgetProvider));
exports.ResourcePropertyViewWidgetProvider = ResourcePropertyViewWidgetProvider;
//# sourceMappingURL=resource-property-view-widget-provider.js.map