/********************************************************************************
 * Copyright (C) 2019 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { PreferenceSchema, PreferenceProxy, PreferenceService } from '@theia/core/lib/browser/preferences';
import { interfaces } from '@theia/core/shared/inversify';
export declare const searchInWorkspacePreferencesSchema: PreferenceSchema;
export declare class SearchInWorkspaceConfiguration {
    'search.lineNumbers': boolean;
    'search.collapseResults': string;
    'search.searchOnType': boolean;
    'search.searchOnTypeDebouncePeriod': number;
    'search.searchOnEditorModification': boolean;
    'search.smartCase': boolean;
}
export declare const SearchInWorkspacePreferences: unique symbol;
export declare type SearchInWorkspacePreferences = PreferenceProxy<SearchInWorkspaceConfiguration>;
export declare function createSearchInWorkspacePreferences(preferences: PreferenceService): SearchInWorkspacePreferences;
export declare function bindSearchInWorkspacePreferences(bind: interfaces.Bind): void;
//# sourceMappingURL=search-in-workspace-preferences.d.ts.map