/********************************************************************************
 * Copyright (C) 2020 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { VSXExtensionRaw, VSXSearchParam, VSXSearchResult, VSXAllVersions } from './vsx-registry-types';
import { VSXEnvironment } from './vsx-environment';
import { VSXApiVersionProvider } from './vsx-api-version-provider';
export interface VSXResponseError extends Error {
    statusCode: number;
}
export declare namespace VSXResponseError {
    function is(error: any): error is VSXResponseError;
}
export declare class VSXRegistryAPI {
    protected readonly apiVersionProvider: VSXApiVersionProvider;
    protected readonly environment: VSXEnvironment;
    search(param?: VSXSearchParam): Promise<VSXSearchResult>;
    protected buildSearchUri(param?: VSXSearchParam): Promise<string>;
    getExtension(id: string): Promise<VSXExtensionRaw>;
    /**
     * Get all versions of the given extension.
     * @param id the requested extension id.
     */
    getAllVersions(id: string): Promise<VSXExtensionRaw[]>;
    protected fetchJson<R>(url: string): Promise<R>;
    protected postJson<P, R>(url: string, payload: P): Promise<R>;
    fetchText(url: string): Promise<string>;
    /**
     * Get the latest compatible extension version.
     * - an extension satisfies compatibility if its `engines.vscode` version is supported.
     * @param id the extension id.
     *
     * @returns the data for the latest compatible extension version if available, else `undefined`.
     */
    getLatestCompatibleExtensionVersion(id: string): Promise<VSXExtensionRaw | undefined>;
    /**
     * Get the latest compatible version of an extension.
     * @param versions the `allVersions` property.
     *
     * @returns the latest compatible version of an extension if it exists, else `undefined`.
     */
    getLatestCompatibleVersion(versions: VSXAllVersions[]): VSXAllVersions | undefined;
    /**
     * Determine if the engine is supported by the application.
     * @param engine the engine.
     *
     * @returns `true` if the engine satisfies the API version.
     */
    protected isEngineSupported(engine?: string): boolean;
}
//# sourceMappingURL=vsx-registry-api.d.ts.map