/********************************************************************************
 * Copyright (C) 2018 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { QuickOpenService, QuickOpenModel, QuickOpenItem, QuickOpenGroupItem, LabelProvider } from '@theia/core/lib/browser';
import { EnvVariablesServer } from '@theia/core/lib/common/env-variables';
import { WorkspaceService } from './workspace-service';
import { WorkspacePreferences } from './workspace-preferences';
import { FileService } from '@theia/filesystem/lib/browser/file-service';
export declare class QuickOpenWorkspace implements QuickOpenModel {
    protected items: QuickOpenGroupItem[];
    protected opened: boolean;
    protected readonly quickOpenService: QuickOpenService;
    protected readonly workspaceService: WorkspaceService;
    protected readonly fileService: FileService;
    protected readonly labelProvider: LabelProvider;
    protected preferences: WorkspacePreferences;
    protected readonly envServer: EnvVariablesServer;
    open(workspaces: string[]): Promise<void>;
    onType(lookFor: string, acceptor: (items: QuickOpenItem[]) => void): void;
    select(): void;
}
//# sourceMappingURL=quick-open-workspace.d.ts.map