/********************************************************************************
 * Copyright (C) 2021 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { JsonSchemaContribution, JsonSchemaRegisterContext } from '@theia/core/lib/browser/json-schema-store';
import { InMemoryResources } from '@theia/core/lib/common';
import { IJSONSchema } from '@theia/core/lib/common/json-schema';
import URI from '@theia/core/lib/common/uri';
import { Deferred } from '@theia/core/lib/common/promise-util';
export interface SchemaUpdateMessage {
    key: string;
    schema?: IJSONSchema;
    deferred: Deferred<boolean>;
}
export declare namespace AddKeyMessage {
    const is: (message: SchemaUpdateMessage | undefined) => message is Required<SchemaUpdateMessage>;
}
export declare class WorkspaceSchemaUpdater implements JsonSchemaContribution {
    protected readonly uri: URI;
    protected readonly editQueue: SchemaUpdateMessage[];
    protected safeToHandleQueue: Deferred<unknown>;
    protected readonly inmemoryResources: InMemoryResources;
    protected init(): void;
    registerSchemas(context: JsonSchemaRegisterContext): void;
    protected retrieveCurrent(): Promise<WorkspaceSchema>;
    updateSchema(message: Omit<SchemaUpdateMessage, 'deferred'>): Promise<boolean>;
    protected handleQueue(): Promise<void>;
    protected addKey({ key, schema, deferred }: Required<SchemaUpdateMessage>, cache: WorkspaceSchema): void;
    protected removeKey({ key, deferred }: SchemaUpdateMessage, cache: WorkspaceSchema): void;
}
export declare type WorkspaceSchema = Required<Pick<IJSONSchema, 'properties' | 'required'>>;
export declare namespace WorkspaceSchema {
    const is: (candidate: any) => candidate is Required<Pick<IJSONSchema, "properties" | "required">>;
}
export declare const workspaceSchemaId = "vscode://schemas/workspace";
export declare const workspaceSchema: IJSONSchema;
//# sourceMappingURL=workspace-schema-updater.d.ts.map