"use strict";
/**********************************************************************
 * Copyright (c) 2021 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CheTheiaComponentFinder = void 0;
const inversify_1 = require("inversify");
/**
 * Need to find che theia component from main dev workspace or from a template
 */
let CheTheiaComponentFinder = class CheTheiaComponentFinder {
    async find(devfileContext) {
        // need to find definition
        var _a, _b, _c, _d, _e;
        // first, search in all templates
        for (const template of devfileContext.devWorkspaceTemplates) {
            const theiaComponent = (_b = (_a = template.spec) === null || _a === void 0 ? void 0 : _a.components) === null || _b === void 0 ? void 0 : _b.find(component => component.name === 'theia-ide');
            // got one
            if (theiaComponent) {
                return theiaComponent;
            }
        }
        // then search in main devWorkspace
        const theiaComponent = (_e = (_d = (_c = devfileContext.devWorkspace.spec) === null || _c === void 0 ? void 0 : _c.template) === null || _d === void 0 ? void 0 : _d.components) === null || _e === void 0 ? void 0 : _e.find(component => component.name === 'theia-ide');
        // got one
        if (theiaComponent) {
            return theiaComponent;
        }
        throw new Error('Not able to find theia-ide component in DevWorkspace and its templates');
    }
};
CheTheiaComponentFinder = __decorate([
    inversify_1.injectable()
], CheTheiaComponentFinder);
exports.CheTheiaComponentFinder = CheTheiaComponentFinder;
//# sourceMappingURL=che-theia-component-finder.js.map