"use strict";
/**********************************************************************
 * Copyright (c) 2021 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DevContainerComponentUpdater = void 0;
const inversify_1 = require("inversify");
const container_plugin_remote_updater_1 = require("./container-plugin-remote-updater");
const dev_container_component_finder_1 = require("./dev-container-component-finder");
/**
 * Apply to the DevWorkspace component the information specified in a given DevContainer struct like preferences/extensions/endpoints, etc.
 */
let DevContainerComponentUpdater = class DevContainerComponentUpdater {
    async insert(devfileContext, vSCodeExtensionDevContainer) {
        var _a, _b, _c;
        const devContainerComponent = await this.devContainerComponentFinder.find(devfileContext);
        const devContainer = devContainerComponent.container;
        if (!devContainer) {
            throw new Error('The dev container should be a component with type "container".');
        }
        // add attributes
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        let attributes = devContainerComponent.attributes;
        if (!attributes) {
            attributes = {};
            devContainerComponent.attributes = attributes;
        }
        // extensions
        attributes['che-theia.eclipse.org/vscode-extensions'] = vSCodeExtensionDevContainer.extensions;
        // add preferences only if there are one
        if (vSCodeExtensionDevContainer.preferences && Object.keys(vSCodeExtensionDevContainer.preferences).length > 0) {
            attributes['che-theia.eclipse.org/vscode-preferences'] = vSCodeExtensionDevContainer.preferences;
        }
        attributes['app.kubernetes.io/name'] = devContainerComponent.name;
        // no endpoints ? initialize empty array
        if (!devContainer.endpoints) {
            devContainer.endpoints = [];
        }
        const toInsertEndpoints = vSCodeExtensionDevContainer.endpoints || [];
        devContainer.endpoints.push(...toInsertEndpoints);
        // no env ? initialize empty array
        if (!devContainer.env) {
            devContainer.env = [];
        }
        const toInsertEnvs = vSCodeExtensionDevContainer.env || [];
        devContainer.env.push(...toInsertEnvs);
        // no volumeMounts ? initialize empty array
        const devContainerVolumes = devContainer.volumeMounts || [];
        devContainer.volumeMounts = devContainerVolumes;
        // pick up only volumes that are not already defined
        const toInsertVolumeMounts = (vSCodeExtensionDevContainer.volumeMounts || []).filter(volume => !devContainerVolumes.some(containerVolume => containerVolume.name === volume.name));
        devContainer.volumeMounts.push(...toInsertVolumeMounts);
        // grab existing components that are volumes
        const devWorkspaceComponents = ((_c = (_b = (_a = devfileContext.devWorkspace) === null || _a === void 0 ? void 0 : _a.spec) === null || _b === void 0 ? void 0 : _b.template) === null || _c === void 0 ? void 0 : _c.components) || [];
        const volumeComponents = devWorkspaceComponents
            .filter(component => component.volume)
            .map(component => component.name);
        // keep only the volumes that are not yet there
        const volumeComponentsToAdd = toInsertVolumeMounts
            .filter(volumeMount => !volumeComponents.includes(volumeMount.name))
            .map(volume => ({ name: volume.name, volume: {} }));
        volumeComponentsToAdd.forEach(volumeComponent => {
            devWorkspaceComponents.push(volumeComponent);
        });
        // need to tweak the entrypoint to call the ${PLUGIN_REMOTE_ENDPOINT_EXECUTABLE}
        devContainer.args = ['sh', '-c', '${PLUGIN_REMOTE_ENDPOINT_EXECUTABLE}'];
        // now, need to add the common stuff
        this.containerPluginRemoteUpdater.update(devContainerComponent.name, devContainer);
        if (devContainer.endpoints.length === 0) {
            delete devContainer.endpoints;
        }
        if (devContainer.volumeMounts.length === 0) {
            delete devContainer.volumeMounts;
        }
    }
};
__decorate([
    inversify_1.inject(dev_container_component_finder_1.DevContainerComponentFinder),
    __metadata("design:type", dev_container_component_finder_1.DevContainerComponentFinder)
], DevContainerComponentUpdater.prototype, "devContainerComponentFinder", void 0);
__decorate([
    inversify_1.inject(container_plugin_remote_updater_1.ContainerPluginRemoteUpdater),
    __metadata("design:type", container_plugin_remote_updater_1.ContainerPluginRemoteUpdater)
], DevContainerComponentUpdater.prototype, "containerPluginRemoteUpdater", void 0);
DevContainerComponentUpdater = __decorate([
    inversify_1.injectable()
], DevContainerComponentUpdater);
exports.DevContainerComponentUpdater = DevContainerComponentUpdater;
//# sourceMappingURL=dev-container-component-updater.js.map