"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Generate = void 0;
/**********************************************************************
 * Copyright (c) 2021 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
require("reflect-metadata");
const fs = require("fs-extra");
const jsYaml = require("js-yaml");
const inversify_1 = require("inversify");
const che_theia_plugins_devfile_resolver_1 = require("./devfile/che-theia-plugins-devfile-resolver");
const github_resolver_1 = require("./github/github-resolver");
const plugin_registry_resolver_1 = require("./plugin-registry/plugin-registry-resolver");
const url_fetcher_1 = require("./fetch/url-fetcher");
let Generate = class Generate {
    async generate(devfileUrl, editorEntry, sidecarPolicy, outputFile) {
        // gets the github URL
        const githubUrl = this.githubResolver.resolve(devfileUrl);
        // user devfile
        const userDevfileContent = await this.urlFetcher.fetchText(githubUrl.getContentUrl('devfile.yaml'));
        const devfile = jsYaml.load(userDevfileContent);
        // sets the suffix to the devfile name
        const suffix = devfile.metadata.name || '';
        // devfile of the editor
        const editorDevfile = await this.pluginRegistryResolver.loadDevfilePlugin(editorEntry);
        // transform it into a devWorkspace template
        const metadata = editorDevfile.metadata;
        // add sufix
        metadata.name = `${metadata.name}-${suffix}`;
        delete editorDevfile.metadata;
        delete editorDevfile.schemaVersion;
        const editorDevWorkspaceTemplate = {
            apiVersion: 'workspace.devfile.io/v1alpha2',
            kind: 'DevWorkspaceTemplate',
            metadata,
            spec: editorDevfile,
        };
        // grab the content of the .vscode/extensions.json and .che/che-theia-plugins.yaml files
        const vscodeExtensionsJsonContent = await this.urlFetcher.fetchTextOptionalContent(githubUrl.getContentUrl('.vscode/extensions.json'));
        const cheTheiaPluginsContent = await this.urlFetcher.fetchTextOptionalContent(githubUrl.getContentUrl('.che/che-theia-plugins.yaml'));
        // transform it into a devWorkspace
        const devfileMetadata = devfile.metadata;
        delete devfile.schemaVersion;
        delete devfile.metadata;
        const devWorkspace = {
            apiVersion: 'workspace.devfile.io/v1alpha2',
            kind: 'DevWorkspace',
            metadata: devfileMetadata,
            spec: {
                started: true,
                template: devfile,
            },
        };
        // for now the list of devWorkspace templates is only the editor template
        const devWorkspaceTemplates = [editorDevWorkspaceTemplate];
        await this.cheTheiaPluginsDevfileResolver.handle({
            devfile: userDevfileContent,
            vscodeExtensionsJsonContent,
            cheTheiaPluginsContent,
            devWorkspace,
            devWorkspaceTemplates,
            sidecarPolicy,
            suffix,
        });
        // write templates and then DevWorkspace in a single file
        const allContentArray = devWorkspaceTemplates.map(template => jsYaml.dump(template));
        allContentArray.push(jsYaml.dump(devWorkspace));
        const generatedContent = allContentArray.join('---\n');
        await fs.writeFile(outputFile, generatedContent, 'utf-8');
    }
};
__decorate([
    inversify_1.inject(url_fetcher_1.UrlFetcher),
    __metadata("design:type", url_fetcher_1.UrlFetcher)
], Generate.prototype, "urlFetcher", void 0);
__decorate([
    inversify_1.inject(che_theia_plugins_devfile_resolver_1.CheTheiaPluginsDevfileResolver),
    __metadata("design:type", che_theia_plugins_devfile_resolver_1.CheTheiaPluginsDevfileResolver)
], Generate.prototype, "cheTheiaPluginsDevfileResolver", void 0);
__decorate([
    inversify_1.inject(plugin_registry_resolver_1.PluginRegistryResolver),
    __metadata("design:type", plugin_registry_resolver_1.PluginRegistryResolver)
], Generate.prototype, "pluginRegistryResolver", void 0);
__decorate([
    inversify_1.inject(github_resolver_1.GithubResolver),
    __metadata("design:type", github_resolver_1.GithubResolver)
], Generate.prototype, "githubResolver", void 0);
Generate = __decorate([
    inversify_1.injectable()
], Generate);
exports.Generate = Generate;
//# sourceMappingURL=generate.js.map