import { makePropertyInjectDecorator, makePropertyMultiInjectDecorator, makePropertyInjectTaggedDecorator, makePropertyInjectNamedDecorator } from "./decorators";
function getDecorators(container, doCache) {
    if (doCache === void 0) { doCache = true; }
    var lazyInject = makePropertyInjectDecorator(container, doCache);
    var lazyInjectNamed = makePropertyInjectNamedDecorator(container, doCache);
    var lazyInjectTagged = makePropertyInjectTaggedDecorator(container, doCache);
    var lazyMultiInject = makePropertyMultiInjectDecorator(container, doCache);
    return {
        lazyInject: lazyInject,
        lazyInjectNamed: lazyInjectNamed,
        lazyInjectTagged: lazyInjectTagged,
        lazyMultiInject: lazyMultiInject
    };
}
export default getDecorators;
