import { ComponentClass, Component } from 'react';
import { interfaces } from 'inversify';
declare const ReactContextKey = "container";
declare const AdministrationKey = "~$inversify-react";
interface ServiceDescriptor {
    scope: interfaces.BindingScope;
    service: interfaces.ServiceIdentifier<any>;
}
interface DiClassAdministration {
    accepts: boolean;
    provides: boolean;
    services: ServiceDescriptor[];
}
interface DiInstanceAdministration {
    container: interfaces.Container;
    properties: {
        [key: string]: () => any;
    };
}
declare function getClassAdministration(target: any): DiClassAdministration;
declare function getInstanceAdministration(target: any): DiInstanceAdministration;
declare function ensureAcceptContext<P>(target: ComponentClass<P>): void;
declare function ensureProvideContext<P, T>(target: ComponentClass<P>, service: interfaces.ServiceIdentifier<T>, scope?: interfaces.BindingScope): void;
declare function getContainer<P>(target: Component<P, any>): interfaces.Container;
interface PropertyOptions {
    isOptional?: boolean;
    defaultValue?: any;
}
declare function createProperty<P>(target: Component<P, any>, name: string, type: interfaces.ServiceIdentifier<any>, options: PropertyOptions): PropertyDescriptor;
export { ReactContextKey, AdministrationKey, ServiceDescriptor, DiClassAdministration, DiInstanceAdministration, ensureAcceptContext, ensureProvideContext, getContainer, createProperty, PropertyOptions, getClassAdministration, getInstanceAdministration, };
