/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import './indentGuides.css';
import { DynamicViewOverlay } from '../../view/dynamicViewOverlay';
import { Position } from '../../../common/core/position';
import { editorActiveIndentGuides, editorIndentGuides } from '../../../common/view/editorColorRegistry';
import { registerThemingParticipant } from '../../../../platform/theme/common/themeService';
var IndentGuidesOverlay = /** @class */ (function (_super) {
    __extends(IndentGuidesOverlay, _super);
    function IndentGuidesOverlay(context) {
        var _this = _super.call(this) || this;
        _this._context = context;
        _this._primaryLineNumber = 0;
        var options = _this._context.configuration.options;
        var wrappingInfo = options.get(108 /* wrappingInfo */);
        var fontInfo = options.get(34 /* fontInfo */);
        _this._lineHeight = options.get(49 /* lineHeight */);
        _this._spaceWidth = fontInfo.spaceWidth;
        _this._enabled = options.get(70 /* renderIndentGuides */);
        _this._activeIndentEnabled = options.get(43 /* highlightActiveIndentGuide */);
        _this._maxIndentLeft = wrappingInfo.wrappingColumn === -1 ? -1 : (wrappingInfo.wrappingColumn * fontInfo.typicalHalfwidthCharacterWidth);
        _this._renderResult = null;
        _this._context.addEventHandler(_this);
        return _this;
    }
    IndentGuidesOverlay.prototype.dispose = function () {
        this._context.removeEventHandler(this);
        this._renderResult = null;
        _super.prototype.dispose.call(this);
    };
    // --- begin event handlers
    IndentGuidesOverlay.prototype.onConfigurationChanged = function (e) {
        var options = this._context.configuration.options;
        var wrappingInfo = options.get(108 /* wrappingInfo */);
        var fontInfo = options.get(34 /* fontInfo */);
        this._lineHeight = options.get(49 /* lineHeight */);
        this._spaceWidth = fontInfo.spaceWidth;
        this._enabled = options.get(70 /* renderIndentGuides */);
        this._activeIndentEnabled = options.get(43 /* highlightActiveIndentGuide */);
        this._maxIndentLeft = wrappingInfo.wrappingColumn === -1 ? -1 : (wrappingInfo.wrappingColumn * fontInfo.typicalHalfwidthCharacterWidth);
        return true;
    };
    IndentGuidesOverlay.prototype.onCursorStateChanged = function (e) {
        var selection = e.selections[0];
        var newPrimaryLineNumber = selection.isEmpty() ? selection.positionLineNumber : 0;
        if (this._primaryLineNumber !== newPrimaryLineNumber) {
            this._primaryLineNumber = newPrimaryLineNumber;
            return true;
        }
        return false;
    };
    IndentGuidesOverlay.prototype.onDecorationsChanged = function (e) {
        // true for inline decorations
        return true;
    };
    IndentGuidesOverlay.prototype.onFlushed = function (e) {
        return true;
    };
    IndentGuidesOverlay.prototype.onLinesChanged = function (e) {
        return true;
    };
    IndentGuidesOverlay.prototype.onLinesDeleted = function (e) {
        return true;
    };
    IndentGuidesOverlay.prototype.onLinesInserted = function (e) {
        return true;
    };
    IndentGuidesOverlay.prototype.onScrollChanged = function (e) {
        return e.scrollTopChanged; // || e.scrollWidthChanged;
    };
    IndentGuidesOverlay.prototype.onZonesChanged = function (e) {
        return true;
    };
    IndentGuidesOverlay.prototype.onLanguageConfigurationChanged = function (e) {
        return true;
    };
    // --- end event handlers
    IndentGuidesOverlay.prototype.prepareRender = function (ctx) {
        if (!this._enabled) {
            this._renderResult = null;
            return;
        }
        var visibleStartLineNumber = ctx.visibleRange.startLineNumber;
        var visibleEndLineNumber = ctx.visibleRange.endLineNumber;
        var indentSize = this._context.model.getOptions().indentSize;
        var indentWidth = indentSize * this._spaceWidth;
        var scrollWidth = ctx.scrollWidth;
        var lineHeight = this._lineHeight;
        var indents = this._context.model.getLinesIndentGuides(visibleStartLineNumber, visibleEndLineNumber);
        var activeIndentStartLineNumber = 0;
        var activeIndentEndLineNumber = 0;
        var activeIndentLevel = 0;
        if (this._activeIndentEnabled && this._primaryLineNumber) {
            var activeIndentInfo = this._context.model.getActiveIndentGuide(this._primaryLineNumber, visibleStartLineNumber, visibleEndLineNumber);
            activeIndentStartLineNumber = activeIndentInfo.startLineNumber;
            activeIndentEndLineNumber = activeIndentInfo.endLineNumber;
            activeIndentLevel = activeIndentInfo.indent;
        }
        var output = [];
        for (var lineNumber = visibleStartLineNumber; lineNumber <= visibleEndLineNumber; lineNumber++) {
            var containsActiveIndentGuide = (activeIndentStartLineNumber <= lineNumber && lineNumber <= activeIndentEndLineNumber);
            var lineIndex = lineNumber - visibleStartLineNumber;
            var indent = indents[lineIndex];
            var result = '';
            if (indent >= 1) {
                var leftMostVisiblePosition = ctx.visibleRangeForPosition(new Position(lineNumber, 1));
                var left = leftMostVisiblePosition ? leftMostVisiblePosition.left : 0;
                for (var i = 1; i <= indent; i++) {
                    var className = (containsActiveIndentGuide && i === activeIndentLevel ? 'cigra' : 'cigr');
                    result += "<div class=\"" + className + "\" style=\"left:" + left + "px;height:" + lineHeight + "px;width:" + indentWidth + "px\"></div>";
                    left += indentWidth;
                    if (left > scrollWidth || (this._maxIndentLeft > 0 && left > this._maxIndentLeft)) {
                        break;
                    }
                }
            }
            output[lineIndex] = result;
        }
        this._renderResult = output;
    };
    IndentGuidesOverlay.prototype.render = function (startLineNumber, lineNumber) {
        if (!this._renderResult) {
            return '';
        }
        var lineIndex = lineNumber - startLineNumber;
        if (lineIndex < 0 || lineIndex >= this._renderResult.length) {
            return '';
        }
        return this._renderResult[lineIndex];
    };
    return IndentGuidesOverlay;
}(DynamicViewOverlay));
export { IndentGuidesOverlay };
registerThemingParticipant(function (theme, collector) {
    var editorIndentGuidesColor = theme.getColor(editorIndentGuides);
    if (editorIndentGuidesColor) {
        collector.addRule(".monaco-editor .lines-content .cigr { box-shadow: 1px 0 0 0 " + editorIndentGuidesColor + " inset; }");
    }
    var editorActiveIndentGuidesColor = theme.getColor(editorActiveIndentGuides) || editorIndentGuidesColor;
    if (editorActiveIndentGuidesColor) {
        collector.addRule(".monaco-editor .lines-content .cigra { box-shadow: 1px 0 0 0 " + editorActiveIndentGuidesColor + " inset; }");
    }
});
