# umd-compat-loader

Webpack does not like UMD wrappers (this kind of wrapper is generated by TypeScript) of the following:

```javascript
(function (factory) {
    if (typeof module === 'object' && typeof module.exports === 'object') {
        var v = factory(require, exports); if (v !== undefined) module.exports = v;
    }
    else if (typeof define === 'function' && define.amd) {
        define(["require", "exports"], factory);
    }
})(function (require, exports) {
});
```

It fails to follow the require down the commonjs path so dependencies are not resolved. It's not possible to switch Webpack to use the AMD path with the imports loader as the `module` variable is provided by Webpack.

This loader simply removes the UMD wrapper - effectively unwrapping it back to commonjs, the source maps should be remapped accordingly.

If you want to unwrap the UMD wrapper to AMD, provide a query of `amd` to the loader. For example: `umd-compat-loader?amd=true`;

## Experimental TS UMD down-emitted imports() support

Experimental support for transforming down emitted `imports()` from TS 2.4, allows transforming lazy require statements to other values.

An example of automatically bundling modules as separate chunks:

```javascript
loader: 'umd-compat-loader',
options: {
	imports(module, context) {
		const result = path.relative(basePath, path.join(context, module));
		return `promise-loader?global,${result}!${module}`;
	}
}
```

