import { V220DevfileCommands, V220DevfileComponents, V220DevfileComponentsItemsContainerEndpoints, V220DevfileComponentsItemsContainerEnv, V220DevfileComponentsItemsContainerVolumeMounts, V220DevfileProjects, V220DevfileProjectsItemsGit } from '@devfile/api';
import { che } from '@eclipse-che/api';
import { Devfile, DevfileMetadata } from '../api/devfile';
export declare class DevfileConverter {
    readonly CHE_EDITOR_YAML = ".che/che-editor.yaml";
    readonly CHE_THEIA_PLUGINS_YAML = ".che/che-theia-plugins.yaml";
    readonly VSCODE_EXTENSIONS_JSON = ".vscode/extensions.json";
    readonly VSCODE_LAUNCH_JSON = ".vscode/launch.json";
    componentVolumeV1toComponentVolumeV2(componentVolumes?: che.workspace.devfile.DevfileVolume[]): V220DevfileComponentsItemsContainerVolumeMounts[] | undefined;
    componentVolumeV2toComponentVolumeV1(componentVolumes?: V220DevfileComponentsItemsContainerVolumeMounts[]): che.workspace.devfile.DevfileVolume[] | undefined;
    componentEndpointV1toComponentEndpointV2(componentEndpoints?: che.workspace.devfile.Endpoint[]): V220DevfileComponentsItemsContainerEndpoints[] | undefined;
    componentEndpointV2toComponentEndpointV1(componentEndpoints?: V220DevfileComponentsItemsContainerEndpoints[]): che.workspace.devfile.Endpoint[] | undefined;
    componentEnvV1toComponentEnvV2(componentEnvs?: che.workspace.devfile.Env[]): V220DevfileComponentsItemsContainerEnv[] | undefined;
    componentEnvV2toComponentEnvV1(componentEnvs?: V220DevfileComponentsItemsContainerEnv[]): che.workspace.devfile.Env[] | undefined;
    componentV2toComponentV1(componentV2: V220DevfileComponents): che.workspace.devfile.Component;
    componentV1toComponentV2(componentV1: che.workspace.devfile.Component): V220DevfileComponents;
    commandV1toCommandV2(commandV1: che.workspace.devfile.DevfileCommand): V220DevfileCommands;
    commandV2toCommandV1(commandV2: V220DevfileCommands): che.workspace.devfile.DevfileCommand;
    projectV1toProjectV2(projectV1: che.workspace.devfile.Project): V220DevfileProjects;
    projectInfoToProjectSource(project: V220DevfileProjects, projectInfo: V220DevfileProjectsItemsGit): che.workspace.devfile.Source;
    metadataV1toMetadataV2(metadataV1?: che.workspace.devfile.Metadata): DevfileMetadata;
    metadataV2toMetadataV1(metadataV2?: DevfileMetadata): che.workspace.devfile.Metadata;
    projectV2toProjectV1(projectV2: V220DevfileProjects): che.workspace.devfile.Project;
    inlineCheTheiaPluginsYamlFromComponentsV1(devfilev1Components: che.workspace.devfile.Component[]): string | undefined;
    inlineCheEditorYamlFromComponentsV1(devfilev1Components: che.workspace.devfile.Component[]): string | undefined;
    inlineVsCodeExtensionFromComponentsV1(devfilev1Components: che.workspace.devfile.Component[]): string | undefined;
    devfileV1toDevfileV2(devfileV1: che.workspace.devfile.Devfile): Promise<Devfile>;
    processVolumesFromDevfileV2(devfileV2: Devfile): Promise<void>;
    processPluginsAndEditorsFromDevfileV2(devfileV2: Devfile, devfileV1: che.workspace.devfile.Devfile, externalContentAccess?: (filename: string) => Promise<string>): Promise<void>;
    findFirstProjectPath(devfileV1: che.workspace.devfile.Devfile): string | undefined;
    prunePlaceHolderComponents(devfileV1: che.workspace.devfile.Devfile): void;
    fixNightlyImages(devfileV1: che.workspace.devfile.Devfile): void;
    fixMemoryLimit(devfileV1: che.workspace.devfile.Devfile): void;
    processDefaultWorkDirCommands(devfileV1: che.workspace.devfile.Devfile, path: string): Promise<void>;
    devfileV2toDevfileV1(devfileV2: Devfile, externalContentAccess?: (filename: string) => Promise<string>): Promise<che.workspace.devfile.Devfile>;
}
