"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.devfileModule = void 0;
/**********************************************************************
 * Copyright (c) 2021 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
const inversify_1 = require("inversify");
const che_theia_component_finder_1 = require("./che-theia-component-finder");
const che_theia_component_updater_1 = require("./che-theia-component-updater");
const che_theia_plugin_devcontainer_merger_1 = require("./che-theia-plugin-devcontainer-merger");
const che_theia_plugin_sidecar_merger_1 = require("./che-theia-plugin-sidecar-merger");
const che_theia_plugins_analyzer_1 = require("./che-theia-plugins-analyzer");
const che_theia_plugins_devfile_resolver_1 = require("./che-theia-plugins-devfile-resolver");
const container_plugin_remote_updater_1 = require("./container-plugin-remote-updater");
const dev_container_component_finder_1 = require("./dev-container-component-finder");
const dev_container_component_updater_1 = require("./dev-container-component-updater");
const devworkspace_updater_1 = require("./devworkspace-updater");
const sidecar_components_creator_1 = require("./sidecar-components-creator");
const vscode_extension_json_analyzer_1 = require("./vscode-extension-json-analyzer");
const devfileModule = new inversify_1.ContainerModule((bind) => {
    bind(che_theia_component_finder_1.CheTheiaComponentFinder).toSelf().inSingletonScope();
    bind(che_theia_component_updater_1.CheTheiaComponentUpdater).toSelf().inSingletonScope();
    bind(che_theia_plugin_devcontainer_merger_1.CheTheiaPluginDevContainerMerger).toSelf().inSingletonScope();
    bind(che_theia_plugin_sidecar_merger_1.CheTheiaPluginSidecarMerger).toSelf().inSingletonScope();
    bind(container_plugin_remote_updater_1.ContainerPluginRemoteUpdater).toSelf().inSingletonScope();
    bind(dev_container_component_finder_1.DevContainerComponentFinder).toSelf().inSingletonScope();
    bind(dev_container_component_updater_1.DevContainerComponentUpdater).toSelf().inSingletonScope();
    bind(che_theia_plugins_devfile_resolver_1.CheTheiaPluginsDevfileResolver).toSelf().inSingletonScope();
    bind(devworkspace_updater_1.DevWorkspaceUpdater).toSelf().inSingletonScope();
    bind(sidecar_components_creator_1.SidecarComponentsCreator).toSelf().inSingletonScope();
    bind(che_theia_plugins_analyzer_1.CheTheiaPluginsAnalyzer).toSelf().inSingletonScope();
    bind(vscode_extension_json_analyzer_1.VscodeExtensionJsonAnalyzer).toSelf().inSingletonScope();
});
exports.devfileModule = devfileModule;
//# sourceMappingURL=devfile-module.js.map